/**
* \file
*
* \brief The image data arrays of each EPD size
*
* Copyright (c) 2012-2013 Pervasive Displays Inc. All rights reserved.
*
*  Authors: Pervasive Displays Inc.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*  1. Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*  2. Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in
*     the documentation and/or other materials provided with the
*     distribution.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "image_data.h"

#if(USE_EPD_Type==USE_EPD144)
#define image_width_144 128 /**< the resolution of 1.44 inch is 128*96 */
#define image_height_144 96 /**< the image array size of 1.44 inch is 96*16 where 16=128/8 */
unsigned char const image_array_144_1[] = {
		  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,  // 1
		  0x00, 0x03, 0xFF, 0xFB, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0xF3, 0xFE,  // 2
		  0x00, 0x03, 0xC7, 0xBB, 0xEF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xA0, 0x00, 0x12, 0x22,  // 3
		  0x00, 0x03, 0xFB, 0xBB, 0xEF, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xE0, 0x00, 0x12, 0x20,  // 4
		  0x00, 0x03, 0xFD, 0xC0, 0xE8, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xE0, 0x00, 0x12, 0x20,  // 5
		  0x00, 0x03, 0xCE, 0xDB, 0x69, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xF3, 0xE0,  // 6
		  0x00, 0x03, 0xFE, 0xDB, 0xAE, 0x5B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xE0, 0x00, 0x12, 0x20,  // 7
		  0x00, 0x03, 0xCF, 0xDB, 0xAF, 0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xFF, 0xFF, 0xF2, 0x20,  // 8
		  0x00, 0x03, 0xFF, 0xFB, 0xEF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xFF, 0xFF, 0xF2, 0x20,  // 9
		  0x00, 0x03, 0xFF, 0xFF, 0xEC, 0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0xF3, 0xFE,  // 10
		  0x00, 0x03, 0xF7, 0xFF, 0xEB, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,  // 11
		  0x00, 0x03, 0xFB, 0xFB, 0xEB, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x10, 0x00,  // 12
		  0x00, 0x03, 0xFD, 0xFB, 0xED, 0xDB, 0xFF, 0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,  // 13
		  0x00, 0x03, 0xFD, 0xFB, 0xEF, 0xFB, 0xFF, 0xE7, 0xFF, 0xE0, 0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0xD8,  // 14
		  0x00, 0x03, 0xFE, 0xFB, 0xEF, 0xFB, 0xFC, 0x00, 0x3F, 0x80, 0x00, 0x0F, 0xE0, 0x00, 0x11, 0x24,  // 15
		  0x00, 0x02, 0x00, 0xFB, 0xEC, 0xEB, 0xF0, 0x00, 0x0F, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF1, 0x24,  // 16
		  0x00, 0x03, 0xFF, 0xFB, 0xEB, 0x6B, 0xE0, 0x00, 0x06, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xF0, 0x88,  // 17
		  0x00, 0x03, 0xFF, 0xFB, 0xEB, 0xAB, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF0, 0x00,  // 18
		  0x00, 0x03, 0xFF, 0xFF, 0xED, 0xCB, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x10, 0x00,  // 19
		  0x00, 0x03, 0xFF, 0xFF, 0xEF, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00,  // 20
		  0x00, 0x03, 0xFF, 0x97, 0xAF, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x10, 0x04,  // 21
		  0x00, 0x03, 0xEF, 0x97, 0xA8, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x04,  // 22
		  0x00, 0x03, 0xEF, 0xF7, 0xAD, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00,  // 23
		  0x00, 0xFB, 0xEF, 0xFB, 0xAF, 0xFA, 0x00, 0x0C, 0x00, 0x00, 0xF0, 0x00, 0x3F, 0xFF, 0xF1, 0x38,  // 24
		  0x00, 0x8B, 0xEF, 0xFB, 0xA0, 0x02, 0x00, 0x7F, 0x80, 0x03, 0xFC, 0x00, 0x3F, 0xFF, 0xF1, 0x44,  // 25
		  0x3C, 0x8B, 0xEF, 0xFB, 0xBF, 0xFE, 0x00, 0xFF, 0x80, 0x07, 0xFE, 0x00, 0x20, 0x00, 0x11, 0x44,  // 26
		  0x24, 0x8B, 0xEF, 0xC0, 0x7F, 0xFE, 0x00, 0xFF, 0xC0, 0x07, 0xFE, 0x00, 0x3F, 0xFF, 0xF1, 0xC8,  // 27
		  0x24, 0xFB, 0xEF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0x80, 0x07, 0xFE, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 28
		  0x24, 0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0x00, 0x03, 0xFC, 0x00, 0x20, 0x00, 0x10, 0xD8,  // 29
		  0x24, 0xFB, 0xE7, 0xD5, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x3F, 0xFF, 0xF1, 0x24,  // 30
		  0x24, 0x8B, 0xF9, 0xD3, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF1, 0x24,  // 31
		  0x3C, 0x8B, 0xFE, 0x86, 0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0xD8,  // 32
		  0x00, 0x8A, 0x00, 0xD2, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x10, 0x00,  // 33
		  0x00, 0xFB, 0xFF, 0xD4, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF1, 0x3E,  // 34
		  0x00, 0x03, 0xFF, 0xD2, 0xBF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0xAA,  // 35
		  0x00, 0x03, 0x03, 0x86, 0x3F, 0xFF, 0xC0, 0x00, 0x02, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x2A,  // 36
		  0x03, 0xC3, 0xFC, 0xD3, 0xFF, 0xFF, 0xE0, 0x00, 0x07, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x10, 0x2A,  // 37
		  0x04, 0x23, 0xFF, 0xD5, 0xFF, 0xFF, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0x03, 0xFF, 0xFF, 0xF3, 0xEA,  // 38
		  0x08, 0x13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x3F, 0xC0, 0x00, 0x0F, 0xE0, 0x00, 0x10, 0x2A,  // 39
		  0x10, 0x0A, 0xFF, 0xD4, 0x3F, 0xFF, 0xFF, 0xF7, 0xFF, 0xF0, 0x00, 0x3F, 0xE0, 0x00, 0x10, 0x2A,  // 40
		  0x10, 0x0A, 0x1F, 0xD5, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xAA,  // 41
		  0x1F, 0x03, 0x67, 0x85, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x11, 0x2A,  // 42
		  0x10, 0xC3, 0x7B, 0xD5, 0xBF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,  // 43
		  0x10, 0x23, 0x7D, 0xD4, 0x3F, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFC, 0x00, 0x20, 0x00, 0x10, 0x00,  // 44
		  0x08, 0x13, 0x7E, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 45
		  0x06, 0x13, 0x7E, 0xAA, 0x3F, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x20, 0x00, 0x13, 0xFE,  // 46
		  0x01, 0xE3, 0x7F, 0xAA, 0xBF, 0xFF, 0xF0, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x20, 0x00, 0x12, 0x82,  // 47
		  0x00, 0x03, 0xFF, 0xAA, 0x3F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x20, 0x00, 0x12, 0xBA,  // 48
		  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x3F, 0xFF, 0xF3, 0xEA,  // 49
		  0x01, 0x03, 0xFB, 0xEF, 0xFF, 0xDF, 0x80, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x3F, 0xFF, 0xF2, 0xAA,  // 50
		  0x09, 0x03, 0xB7, 0x80, 0xF8, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x13, 0xFE,  // 51
		  0x09, 0x7B, 0xAD, 0xEF, 0x79, 0xDE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF3, 0x00,  // 52
		  0x09, 0x4A, 0x00, 0xEF, 0xBE, 0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0xFE,  // 53
		  0x09, 0x4B, 0xAD, 0xEF, 0xBF, 0x9E, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x40,  // 54
		  0x3F, 0x4B, 0xB7, 0xFF, 0xFF, 0xFC, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 55
		  0x09, 0x4A, 0x7B, 0xFF, 0xFC, 0xEC, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 56
		  0x09, 0x4B, 0x80, 0x80, 0x7B, 0x6C, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 57
		  0x39, 0x7B, 0xDF, 0xFF, 0xFB, 0xAC, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00,  // 58
		  0x09, 0x03, 0x4E, 0xDB, 0xBD, 0xCE, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 59
		  0x05, 0x03, 0x55, 0xDB, 0xBF, 0xFE, 0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00,  // 60
		  0x00, 0x03, 0x0B, 0xFB, 0xBC, 0xEE, 0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xF0, 0x00,  // 61
		  0x00, 0x02, 0x65, 0xEB, 0x3B, 0x6F, 0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x20, 0x00, 0x10, 0xFE,  // 62
		  0x08, 0x0B, 0x36, 0xEF, 0xFB, 0xAF, 0x80, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x20, 0x00, 0x10, 0x40,  // 63
		  0x08, 0x33, 0x40, 0x87, 0xFD, 0xCF, 0xC0, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x20, 0x00, 0x10, 0x00,  // 64
		  0x08, 0x53, 0xEF, 0xE8, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x20, 0x00, 0x10, 0x00,  // 65
		  0x08, 0x0B, 0x69, 0xEF, 0x3C, 0x1F, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xF0, 0x00,  // 66
		  0x3B, 0x8A, 0xDE, 0xFF, 0xFB, 0x6F, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x20, 0x00, 0x10, 0x00,  // 67
		  0x08, 0x6B, 0xFF, 0xFF, 0xFB, 0x6F, 0xFE, 0x00, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xF0, 0x00,  // 68
		  0x08, 0x1B, 0xFF, 0xFF, 0xFC, 0xDF, 0xFF, 0xC0, 0x1F, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xF0, 0x00,  // 69
		  0x08, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x10, 0x00,  // 70
		  0x08, 0x03, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x10, 0x00,  // 71
		  0x0F, 0xE3, 0xFF, 0xBF, 0x7F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,  // 72
		  0x00, 0x1B, 0xFF, 0xDE, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,  // 73
		  0x00, 0x03, 0xFF, 0xED, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x10, 0x00,  // 74
		  0x00, 0x03, 0xFF, 0xF3, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00,  // 75
		  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00,  // 76
		  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF,  // 77
		  0x00, 0x03, 0xB7, 0xEF, 0xBF, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF,  // 78
		  0x00, 0x03, 0xAF, 0x88, 0x38, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1F, 0x3B,  // 79
		  0x00, 0x02, 0x00, 0xAA, 0xB9, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFE, 0xDB,  // 80
		  0x00, 0x03, 0xAF, 0x8A, 0xBE, 0x5F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1E, 0xEB,  // 81
		  0x00, 0x03, 0xB7, 0xA2, 0xBF, 0x9F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1F, 0x73,  // 82
		  0x00, 0x03, 0xFF, 0x8A, 0xB8, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF,  // 83
		  0x00, 0x03, 0xAF, 0xA8, 0x39, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1F, 0xFF,  // 84
		  0x00, 0x02, 0x00, 0x8F, 0xBE, 0x5F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x03,  // 85
		  0x00, 0x03, 0xA7, 0xE8, 0x3F, 0x9F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F,  // 86
		  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xDF, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 87
		  0x00, 0x03, 0xE7, 0xFF, 0xF8, 0x0F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFD,  // 88
		  0x00, 0x03, 0xDF, 0xFB, 0xF9, 0xDF, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,  // 89
		  0x00, 0x03, 0xFF, 0xFB, 0xFE, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xF7,  // 90
		  0x00, 0x03, 0xFF, 0xF7, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF,  // 91
		  0x00, 0x02, 0x00, 0xF7, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F,  // 92
		  0x00, 0x03, 0xFE, 0x80, 0x38, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xEF,  // 93
		  0x00, 0x03, 0xFF, 0xFF, 0xF9, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xF7,  // 94
		  0x00, 0x03, 0xCF, 0xFF, 0xFE, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,  // 95
		  0x00, 0x03, 0xF7, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD   // 96
		};


unsigned char const image_array_144_2[] = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
  0xFF, 0xFF, 0xC0, 0x3C, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
  0xFF, 0xFE, 0x1E, 0x10, 0x78, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
  0xFF, 0xFC, 0x30, 0x7F, 0x0C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
  0xFF, 0xF8, 0x67, 0xFF, 0xE2, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
  0xFF, 0xF8, 0x4F, 0xFF, 0xFA, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
  0xFF, 0xFA, 0x1F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
  0xFF, 0xF8, 0x3F, 0xFF, 0xBC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
  0xFF, 0xF8, 0x3B, 0xFF, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
  0xFF, 0xFD, 0xF9, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
  0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 12
  0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 13
  0xFF, 0xFF, 0xFE, 0x07, 0x80, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 14
  0xFF, 0xFF, 0xF9, 0xF3, 0x23, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 15
  0xFF, 0xFF, 0xF3, 0xC0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 16
  0xFF, 0xBB, 0xE6, 0x00, 0x1C, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 17
  0xFF, 0x73, 0x98, 0x1C, 0x3F, 0xCD, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFF, 0xE0, 0x1F, 0xFF,  // 18
  0xFF, 0x71, 0x30, 0xFC, 0x41, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0x80, 0x07, 0xFF,  // 19
  0xFF, 0x70, 0x03, 0xC0, 0x60, 0x1D, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFE, 0x00, 0x07, 0xFF,  // 20
  0xFE, 0x70, 0x07, 0x0C, 0x1F, 0xBD, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFC, 0x00, 0x07, 0xFF,  // 21
  0xFE, 0x73, 0x3E, 0x3C, 0xC0, 0x3D, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x07, 0xF8, 0x00, 0x07, 0xFF,  // 22
  0xFE, 0x78, 0xF8, 0x79, 0xE0, 0xFB, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xC7, 0xF0, 0x0F, 0xC7, 0xFF,  // 23
  0xFE, 0x78, 0x01, 0xF1, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF,  // 24
  0xFE, 0x7C, 0x0F, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF,  // 25
  0xFF, 0x3F, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0xE0, 0x7F, 0xFF, 0xFF,  // 26
  0xFF, 0x3F, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF,  // 27
  0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF,  // 28
  0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xE0, 0x3F, 0xC0, 0xE0, 0x3F, 0xFF,  // 29
  0xFF, 0xC7, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x0F, 0xC0, 0x00, 0x0F, 0xFF,  // 30
  0xFF, 0xF3, 0xF9, 0xFF, 0xE7, 0x87, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x07, 0xC0, 0x00, 0x07, 0xFF,  // 31
  0xFF, 0xF8, 0xF8, 0x3F, 0xC7, 0x87, 0xFF, 0xFF, 0xEF, 0xC0, 0x00, 0x03, 0xC0, 0x00, 0x03, 0xFF,  // 32
  0xFF, 0xFF, 0xFC, 0x07, 0x07, 0xB7, 0xFF, 0xFF, 0xEF, 0xC0, 0x00, 0x03, 0xC0, 0x00, 0x03, 0xFF,  // 33
  0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xB7, 0xFF, 0xFF, 0x83, 0xC0, 0x3E, 0x01, 0xC0, 0x3E, 0x01, 0xFF,  // 34
  0xFF, 0xFF, 0xFC, 0x00, 0x07, 0x37, 0xFF, 0xFF, 0x39, 0xC0, 0xFF, 0x01, 0xC0, 0xFF, 0x01, 0xFF,  // 35
  0xFF, 0xFF, 0xFC, 0x00, 0x07, 0x77, 0xFF, 0xFE, 0x7F, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81, 0xFF,  // 36
  0xFF, 0xFF, 0xFE, 0x01, 0x07, 0x77, 0xFF, 0xFE, 0x7F, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81, 0xFF,  // 37
  0xFF, 0xFF, 0xFE, 0x03, 0xE4, 0x76, 0x1F, 0xFE, 0x7F, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81, 0xFF,  // 38
  0xFF, 0xFF, 0xFE, 0x0F, 0xE0, 0x70, 0x9F, 0xFF, 0x1F, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81, 0xFF,  // 39
  0xFF, 0x87, 0xFE, 0x1F, 0xCF, 0x73, 0xC0, 0x7F, 0x83, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81, 0xFF,  // 40
  0xFE, 0x03, 0xF8, 0x30, 0x1F, 0x73, 0xE7, 0x3F, 0xF1, 0xE0, 0x7F, 0x01, 0xE0, 0x7F, 0x01, 0xFF,  // 41
  0xFC, 0x79, 0xF3, 0x87, 0x1F, 0x77, 0xEF, 0x3F, 0xF9, 0xE0, 0x7F, 0x03, 0xE0, 0x7F, 0x03, 0xFF,  // 42
  0xF9, 0xFC, 0xF3, 0x9F, 0x3F, 0x66, 0xEF, 0x7F, 0xFD, 0xE0, 0x3E, 0x03, 0xE0, 0x3E, 0x03, 0xFF,  // 43
  0xF3, 0xFE, 0xF3, 0xBF, 0xB7, 0x66, 0xFC, 0x7F, 0xF9, 0xF0, 0x00, 0x07, 0xF0, 0x00, 0x07, 0xFF,  // 44
  0xE7, 0xFE, 0x70, 0x3F, 0xB7, 0x6E, 0xF8, 0xFE, 0xF9, 0xF0, 0x00, 0x07, 0xF0, 0x00, 0x07, 0xFF,  // 45
  0xEF, 0x8F, 0x61, 0x9F, 0xB7, 0x6F, 0xD9, 0xFF, 0x07, 0xF8, 0x00, 0x0F, 0xF8, 0x00, 0x0F, 0xFF,  // 46
  0xCF, 0x8F, 0x09, 0x99, 0xB7, 0x6F, 0x9D, 0xFF, 0xDF, 0xFC, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xFF,  // 47
  0x8F, 0x87, 0x0D, 0xD9, 0xF7, 0x6F, 0x1D, 0xFF, 0xDF, 0xFF, 0x80, 0xFF, 0xFF, 0x80, 0xFF, 0xFF,  // 48
  0x8F, 0xC7, 0xFD, 0xD9, 0xF7, 0x6E, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 49
  0xCF, 0xC7, 0xF9, 0xDD, 0xF7, 0x6E, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 50
  0xC1, 0xE7, 0xF9, 0xDD, 0xFF, 0x6F, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 51
  0xE1, 0xE3, 0xF9, 0xDD, 0x9F, 0xEF, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 52
  0xE1, 0xE7, 0xB8, 0xDD, 0x9F, 0x67, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 53
  0xF0, 0xE7, 0x38, 0xDD, 0xCF, 0x00, 0x7B, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF,  // 54
  0xFC, 0xF7, 0x38, 0xED, 0x87, 0x00, 0x63, 0xFC, 0xF1, 0xE3, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF,  // 55
  0xFC, 0xFF, 0x38, 0xEC, 0x06, 0x7E, 0x07, 0xFE, 0xEE, 0xDD, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,  // 56
  0xFC, 0x7F, 0x1C, 0xFC, 0x0E, 0xFF, 0x9F, 0xFE, 0xFE, 0xDD, 0xC3, 0xEF, 0x9F, 0x87, 0x8E, 0x3F,  // 57
  0xFE, 0x7E, 0x1C, 0xE0, 0xDE, 0xFF, 0xFF, 0xFE, 0xF1, 0xDD, 0xB7, 0xDF, 0xDF, 0xBB, 0x7D, 0xFF,  // 58
  0xFE, 0x7E, 0x9C, 0x43, 0xDC, 0xFF, 0xFF, 0xFE, 0xFE, 0xDD, 0xB7, 0xDF, 0xDF, 0xBB, 0x7C, 0xFF,  // 59
  0xFE, 0x3C, 0x9C, 0x0F, 0x89, 0xFF, 0xFF, 0xFE, 0xFE, 0xDD, 0xCF, 0xDF, 0xDF, 0xBB, 0x7F, 0x3F,  // 60
  0xFF, 0x3D, 0xCE, 0x1F, 0x81, 0xFF, 0xFF, 0xFE, 0xEE, 0xDD, 0xBF, 0xBF, 0xDF, 0xBB, 0x7F, 0xBF,  // 61
  0xFF, 0x1C, 0xCC, 0x7F, 0xC7, 0xFF, 0xFF, 0xFC, 0x71, 0xE3, 0xC7, 0xBF, 0xDF, 0x87, 0x8C, 0x7F,  // 62
  0xFF, 0x1E, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0x7F, 0x8F, 0xBF, 0xFF, 0xFF,  // 63
  0xFF, 0x9E, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x7F, 0xFF, 0xBF, 0xFF, 0xFF,  // 64
  0xFF, 0x8E, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 65
  0xFF, 0xCF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 66
  0xFF, 0xCF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 67
  0xFF, 0xC7, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 68
  0xFF, 0xE6, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 69
  0xFF, 0xE0, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 70
  0xFF, 0xE1, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 71
  0xFF, 0xF3, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 72
  0xFF, 0xF3, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 73
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 74
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 75
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 76
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 77
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 78
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 79
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 80
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 81
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 82
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 83
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 84
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 85
  0xFF, 0xFF, 0xFC, 0xB1, 0xA6, 0x37, 0x4E, 0x3A, 0x4F, 0x59, 0x09, 0x61, 0xA7, 0x14, 0xFF, 0xFF,  // 86
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 87
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xC7, 0x1F, 0x70, 0xC6, 0x0C, 0x71, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF,  // 88
  0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xBA, 0xEE, 0x77, 0xBB, 0xDB, 0xAE, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF,  // 89
  0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFB, 0xED, 0x6F, 0xBF, 0xDB, 0xAE, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF,  // 90
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFB, 0x9D, 0x61, 0x87, 0xBC, 0x6E, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF,  // 91
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xF7, 0xEB, 0x7E, 0xBB, 0xBB, 0xB0, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF,  // 92
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xEF, 0xE8, 0x3E, 0xBB, 0x7B, 0xBE, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF,  // 93
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xDE, 0xEF, 0x6E, 0xBB, 0x7B, 0xAE, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF,  // 94
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x83, 0x1F, 0x71, 0xC7, 0x7C, 0x71, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF,  // 95
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 96
};


#elif(USE_EPD_Type==USE_EPD200)

#define image_width_200 200 /**< the resolution of 2 inch is 200*96 */
#define image_height_200 96 /**< the image array size of 2 inch is 96*25 where 25=200/8 */
unsigned char const image_array_200_1[] = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 12
  0xFC, 0x07, 0xC0, 0x38, 0x1C, 0x1F, 0xC7, 0x7F, 0xC1, 0xE3, 0x0F, 0xE2, 0x01, 0xE0, 0x0F, 0xFF, 0xC3, 0xE0, 0x3C, 0x7F, 0xFD, 0xE3, 0xF3, 0xC3, 0xFF,  // 13
  0xFC, 0x01, 0xC0, 0x38, 0x06, 0x1F, 0x8E, 0x7F, 0x80, 0xE3, 0x0F, 0xC6, 0x01, 0xE0, 0x01, 0xE3, 0x80, 0xE0, 0x1C, 0x7F, 0xF9, 0xE3, 0xF3, 0x81, 0xFF,  // 14
  0xFC, 0x70, 0xC7, 0xF8, 0xC2, 0x0F, 0x8E, 0x3F, 0x1C, 0xE3, 0x87, 0xC6, 0x3F, 0xE3, 0xE0, 0xE3, 0x1C, 0xE3, 0x8C, 0x7F, 0xF8, 0xF1, 0xE7, 0x18, 0xFF,  // 15
  0xFC, 0x78, 0xC7, 0xF8, 0xE3, 0x0F, 0x9C, 0x3F, 0x3E, 0xE3, 0x87, 0xCE, 0x3F, 0xE3, 0xF8, 0xE3, 0x3E, 0xE3, 0xCC, 0x7F, 0xF0, 0xF1, 0xE7, 0x3C, 0xFF,  // 16
  0xFC, 0x78, 0xC7, 0xF8, 0xE3, 0x0F, 0x1C, 0x1F, 0x3F, 0xE3, 0xC7, 0x8E, 0x3F, 0xE3, 0xF8, 0x63, 0x3F, 0xE3, 0xCC, 0x7F, 0xF0, 0x78, 0xCF, 0x3F, 0xFF,  // 17
  0xFC, 0x78, 0xC7, 0xF8, 0xE3, 0x87, 0x39, 0x9F, 0x1F, 0xE3, 0xC3, 0x9E, 0x3F, 0xE3, 0xFC, 0x63, 0x1F, 0xE3, 0xCC, 0x7F, 0xE6, 0x7C, 0xCF, 0x1F, 0xFF,  // 18
  0xFC, 0x70, 0xC7, 0xF8, 0xC3, 0x87, 0x39, 0x8F, 0x0F, 0xE3, 0xE3, 0x9E, 0x3F, 0xE3, 0xFC, 0x63, 0x07, 0xE3, 0x8C, 0x7F, 0xE6, 0x7C, 0x1F, 0x87, 0xFF,  // 19
  0xFC, 0x00, 0xC0, 0x38, 0x07, 0xC2, 0x7B, 0xCF, 0x87, 0xE3, 0xE1, 0x3E, 0x01, 0xE3, 0xFC, 0x63, 0x81, 0xE0, 0x1C, 0x7F, 0xEF, 0x3E, 0x1F, 0x83, 0xFF,  // 20
  0xFC, 0x01, 0xC0, 0x38, 0x1F, 0xC2, 0x70, 0x07, 0xC1, 0xE3, 0xE1, 0x3E, 0x01, 0xE3, 0xFC, 0x63, 0xC0, 0xE0, 0x3C, 0x7F, 0xC0, 0x3F, 0x3F, 0xC1, 0xFF,  // 21
  0xFC, 0x7F, 0xC7, 0xF8, 0x0F, 0xC0, 0x70, 0x07, 0xE0, 0xE3, 0xF0, 0x3E, 0x3F, 0xE3, 0xFC, 0x63, 0xF0, 0x63, 0xFC, 0x7F, 0xC0, 0x1F, 0x3F, 0xF0, 0xFF,  // 22
  0xFC, 0x7F, 0xC7, 0xF8, 0x07, 0xE0, 0xE3, 0xC3, 0xF8, 0x63, 0xF0, 0x7E, 0x3F, 0xE3, 0xFC, 0x63, 0xFC, 0x63, 0xFC, 0x7F, 0x9F, 0x1F, 0x3F, 0xF8, 0x7F,  // 23
  0xFC, 0x7F, 0xC7, 0xF8, 0x87, 0xE0, 0xE7, 0xE3, 0xFC, 0x63, 0xF8, 0x7E, 0x3F, 0xE3, 0xF8, 0x63, 0xFC, 0x63, 0xFC, 0x7F, 0x9F, 0x8F, 0x3F, 0xFC, 0x7F,  // 24
  0xFC, 0x7F, 0xC7, 0xF8, 0xC3, 0xF1, 0xC7, 0xE1, 0xBC, 0x63, 0xF8, 0x7E, 0x3F, 0xE3, 0xF0, 0xE3, 0x7C, 0x63, 0xFC, 0x7F, 0x3F, 0x8F, 0x3F, 0x7C, 0x7F,  // 25
  0xFC, 0x7F, 0xC7, 0xF8, 0xE1, 0xF1, 0xCF, 0xF1, 0x1C, 0x63, 0xFC, 0xFE, 0x3F, 0xE3, 0xE1, 0xE2, 0x38, 0xE3, 0xFC, 0x7F, 0x3F, 0xC7, 0x3E, 0x38, 0xFF,  // 26
  0xFC, 0x7F, 0xC0, 0x38, 0xF0, 0xFB, 0x8F, 0xF0, 0x80, 0xE3, 0xFC, 0xFE, 0x01, 0xE0, 0x03, 0xE2, 0x00, 0xE3, 0xFC, 0x02, 0x3F, 0xC7, 0x3F, 0x00, 0xFF,  // 27
  0xFC, 0x7F, 0xC0, 0x38, 0xF8, 0xFB, 0x9F, 0xF8, 0xE1, 0xE3, 0xFF, 0xFE, 0x01, 0xE0, 0x1F, 0xE3, 0x03, 0xE3, 0xFC, 0x02, 0x7F, 0xE3, 0x3F, 0xC3, 0xFF,  // 28
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 29
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 30
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 31
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 32
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 33
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 34
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 35
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xCC, 0xCF, 0xCF, 0x0C, 0x00, 0x0F,  // 36
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xCC, 0xCF, 0xCF, 0x0C, 0x00, 0x0F,  // 37
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFC, 0xF0, 0x0F, 0xCF, 0xFC, 0xFF, 0xCF,  // 38
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFC, 0xF0, 0x0F, 0xCF, 0xFC, 0xFF, 0xCF,  // 39
  0xFF, 0xE1, 0xFF, 0x0F, 0x33, 0xF0, 0x06, 0x03, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0C, 0xC0, 0xF3, 0x3C, 0x3C, 0xC0, 0xCF,  // 40
  0xFF, 0xC0, 0xFE, 0x07, 0x33, 0xF0, 0x06, 0x01, 0xC0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0C, 0xC0, 0xF3, 0x3C, 0x3C, 0xC0, 0xCF,  // 41
  0xFF, 0x8E, 0x7C, 0x63, 0x33, 0xF3, 0xFE, 0x78, 0xCF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0C, 0xC0, 0xC0, 0xF3, 0x3C, 0xC0, 0xCF,  // 42
  0xFF, 0x9E, 0x7C, 0xF3, 0x33, 0xF3, 0xFE, 0x7C, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0C, 0xC0, 0xC0, 0xF3, 0x3C, 0xC0, 0xCF,  // 43
  0xFF, 0xFE, 0x7C, 0xF3, 0xFF, 0xF3, 0xFE, 0x78, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0C, 0xCF, 0x0F, 0x00, 0x3C, 0xC0, 0xCF,  // 44
  0xFF, 0xFC, 0xFC, 0xF3, 0xFF, 0xF0, 0x06, 0x01, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0C, 0xCF, 0x0F, 0x00, 0x3C, 0xC0, 0xCF,  // 45
  0xFF, 0xF8, 0xFC, 0xF3, 0xFF, 0xF0, 0x06, 0x03, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFC, 0xFC, 0x30, 0xCF, 0x3C, 0xFF, 0xCF,  // 46
  0xFF, 0xF1, 0xFC, 0xF3, 0xFF, 0xF3, 0xFE, 0x7F, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFC, 0xFC, 0x30, 0xCF, 0x3C, 0xFF, 0xCF,  // 47
  0xFF, 0xE3, 0xFC, 0xF3, 0xFF, 0xF3, 0xFE, 0x7F, 0xCF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0x00, 0x0F,  // 48
  0xFF, 0x80, 0x66, 0x07, 0xFF, 0xF0, 0x06, 0x7F, 0xC0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCF, 0x33, 0xFF, 0xFF, 0xFF,  // 50
  0xFF, 0x80, 0x67, 0x0F, 0xFF, 0xF0, 0x06, 0x7F, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xCF, 0x33, 0xFF, 0xFF, 0xFF,  // 51
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3C, 0xCC, 0x3C, 0xF0, 0x33, 0xC0, 0xCF,  // 52
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3C, 0xCC, 0x3C, 0xF0, 0x33, 0xC0, 0xCF,  // 53
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x0F, 0x3C, 0xCF, 0xC0, 0x00, 0x0F, 0xCF,  // 54
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x0F, 0x3C, 0xCF, 0xC0, 0x00, 0x0F, 0xCF,  // 55
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0xF0, 0x00, 0xF0, 0xF3, 0x3C, 0x3F,  // 56
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0xF0, 0x00, 0xF0, 0xF3, 0x3C, 0x3F,  // 57
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCF, 0x00, 0x30, 0xCF, 0x00, 0xF3, 0xCF,  // 58
  0xFF, 0xC0, 0x1F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xE7, 0xE6, 0x77, 0xFF, 0xFF, 0xFF, 0xCC, 0xCF, 0x00, 0x30, 0xCF, 0x00, 0xF3, 0xCF,  // 59
  0xFF, 0xC0, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xE7, 0xCE, 0x67, 0xFF, 0xFF, 0xFF, 0xCC, 0xFC, 0xC0, 0xF0, 0x03, 0xFF, 0x30, 0xFF,  // 60
  0xFF, 0xCF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x9F, 0xE7, 0xFF, 0xFF, 0xFF, 0xCC, 0xFC, 0xC0, 0xF0, 0x03, 0xFF, 0x30, 0xFF,  // 61
  0xFF, 0xCF, 0xFC, 0xE0, 0x38, 0xF2, 0x1E, 0x0E, 0x78, 0x79, 0x0F, 0xE7, 0x3E, 0x41, 0xFF, 0xFF, 0xFF, 0xCC, 0xC3, 0x3F, 0xCF, 0x03, 0x30, 0xFF, 0x0F,  // 62
  0xFF, 0xCF, 0xFC, 0x40, 0x30, 0x70, 0x0C, 0x06, 0x70, 0x38, 0x07, 0xE6, 0x7E, 0x41, 0xFF, 0xFF, 0xFF, 0xCC, 0xC3, 0x3F, 0xCF, 0x03, 0x30, 0xFF, 0x0F,  // 63
  0xFF, 0xC0, 0x1E, 0x4C, 0xE7, 0x31, 0xCC, 0xE6, 0x63, 0x18, 0xE7, 0xE4, 0x3E, 0x67, 0xFF, 0xFF, 0xFF, 0xCC, 0xF0, 0x0F, 0xF0, 0xFF, 0x3C, 0xC0, 0x0F,  // 64
  0xFF, 0xC0, 0x1F, 0x1C, 0xE0, 0x33, 0xCC, 0x3E, 0x67, 0x99, 0xE7, 0xE1, 0x3E, 0x67, 0xFF, 0xFF, 0xFF, 0xCC, 0xF0, 0x0F, 0xF0, 0xFF, 0x3C, 0xC0, 0x0F,  // 65
  0xFF, 0xCF, 0xFF, 0x1C, 0xE0, 0x33, 0xCE, 0x0E, 0x67, 0x99, 0xE7, 0xE3, 0x9E, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0xFF, 0xCF, 0x00, 0x3F, 0x3F,  // 66
  0xFF, 0xCF, 0xFF, 0x1C, 0xE7, 0xF3, 0xCF, 0x86, 0x67, 0x99, 0xE7, 0xE7, 0x9E, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0xFF, 0xCF, 0x00, 0x3F, 0x3F,  // 67
  0xFF, 0xCF, 0xFE, 0x4C, 0xE3, 0x33, 0xCC, 0xE6, 0x63, 0x19, 0xE7, 0xE7, 0xCE, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xCF, 0xF3, 0x3C, 0xF3, 0x0F, 0x3F,  // 68
  0xFF, 0xC0, 0x1C, 0x44, 0x30, 0x73, 0xCC, 0x06, 0x70, 0x39, 0xE7, 0xE7, 0xC6, 0x61, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xCF, 0xF3, 0x3C, 0xF3, 0x0F, 0x3F,  // 69
  0xFF, 0xC0, 0x1C, 0xE6, 0x38, 0xF3, 0xCE, 0x0E, 0x78, 0x79, 0xE7, 0xE7, 0xE6, 0x71, 0xFF, 0xFF, 0xFF, 0xC0, 0xCF, 0x3C, 0x00, 0x00, 0xC3, 0xFC, 0x3F,  // 70
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xCF, 0x3C, 0x00, 0x00, 0xC3, 0xFC, 0x3F,  // 71
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x30, 0x3C, 0xF3, 0x0C, 0xCF, 0x30, 0xFF,  // 72
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x30, 0x3C, 0xF3, 0x0C, 0xCF, 0x30, 0xFF,  // 73
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xF3, 0x3F, 0x0F, 0xC0, 0xCC, 0xFC, 0xFF,  // 74
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xF3, 0x3F, 0x0F, 0xC0, 0xCC, 0xFC, 0xFF,  // 75
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x00, 0x3C, 0xFF, 0x00, 0xC0, 0x00, 0xFF,  // 76
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x00, 0x3C, 0xFF, 0x00, 0xC0, 0x00, 0xFF,  // 77
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x33, 0xCF, 0xCF, 0xC0, 0x0F,  // 78
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x33, 0xCF, 0xCF, 0xC0, 0x0F,  // 79
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0x33, 0xCF, 0x0C, 0xC3, 0x3F,  // 80
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0x33, 0xCF, 0x0C, 0xC3, 0x3F,  // 81
  0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0xBF, 0xED, 0xFF, 0xFF, 0xFC, 0x78, 0xF1, 0xFF, 0xFC, 0x78, 0xFF, 0xFF, 0xCF, 0xFC, 0xF3, 0x00, 0x3C, 0xCF, 0xCF, 0xCF,  // 82
  0xFF, 0xEF, 0xBF, 0xFF, 0xFF, 0xBF, 0xEF, 0xFF, 0xFF, 0xFB, 0xB7, 0x6E, 0xFF, 0xFB, 0xB7, 0x7F, 0xFF, 0xCF, 0xFC, 0xF3, 0x00, 0x3C, 0xCF, 0xCF, 0xCF,  // 83
  0xFF, 0xEF, 0xB8, 0xF1, 0xE3, 0xB7, 0x45, 0xC7, 0x4E, 0xFF, 0xB7, 0x6E, 0xF7, 0x7B, 0xB7, 0xFF, 0xFF, 0xCC, 0x0C, 0xFF, 0x00, 0xF0, 0xC0, 0x00, 0x3F,  // 84
  0xFF, 0xEF, 0xB7, 0x6E, 0xDD, 0xB7, 0x6D, 0xBB, 0x37, 0xFF, 0xB7, 0x6E, 0xFA, 0xFB, 0xB4, 0xFF, 0xFF, 0xCC, 0x0C, 0xFF, 0x00, 0xF0, 0xC0, 0x00, 0x3F,  // 85
  0xFF, 0xE0, 0x77, 0x6F, 0xDD, 0xB7, 0x6D, 0xBB, 0x77, 0xFF, 0x77, 0x6E, 0xFA, 0xFB, 0x33, 0x7F, 0xFF, 0xCC, 0x0C, 0xC3, 0xCF, 0x0F, 0x33, 0xC0, 0x0F,  // 86
  0xFF, 0xEE, 0xF0, 0x71, 0xDD, 0xB7, 0x6D, 0xBB, 0x77, 0xFF, 0x77, 0x6E, 0xFD, 0xFC, 0xB7, 0x7F, 0xFF, 0xCC, 0x0C, 0xC3, 0xCF, 0x0F, 0x33, 0xC0, 0x0F,  // 87
  0xFF, 0xEF, 0x77, 0xFE, 0xDD, 0xB7, 0x6D, 0xBB, 0x77, 0xFE, 0xF7, 0x6E, 0xFA, 0xFF, 0xB7, 0x7F, 0xFF, 0xCC, 0x0C, 0xC3, 0xC3, 0xF0, 0x3F, 0x3C, 0xCF,  // 88
  0xFF, 0xEF, 0x77, 0x6E, 0xDD, 0xB7, 0x6D, 0xBB, 0x77, 0xFD, 0xF7, 0x6E, 0xFA, 0xFB, 0xB7, 0x7F, 0xFF, 0xCC, 0x0C, 0xC3, 0xC3, 0xF0, 0x3F, 0x3C, 0xCF,  // 89
  0xFF, 0xEF, 0xB8, 0xF1, 0xE3, 0xB8, 0x65, 0xC7, 0x76, 0xF8, 0x38, 0xF1, 0xF7, 0x7C, 0x78, 0xFF, 0xFF, 0xCF, 0xFC, 0xC3, 0xCF, 0xFC, 0x03, 0x33, 0x3F,  // 90
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFC, 0xC3, 0xCF, 0xFC, 0x03, 0x33, 0x3F,  // 91
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xC3, 0x33, 0xFC, 0x03, 0xF3, 0x3F,  // 92
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xC3, 0x33, 0xFC, 0x03, 0xF3, 0x3F,  // 93
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 94
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 95
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 96
};

unsigned char const image_array_200_2[] = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x34, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x4A, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xB7, 0x43, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
  0xFF, 0xFF, 0x00, 0x7F, 0x0F, 0x00, 0x07, 0x00, 0x07, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x4A, 0xA0, 0xFF, 0xFF, 0xFF, 0xFF,  // 12
  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0x00, 0x07, 0x00, 0x07, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x25, 0x68, 0x7F, 0xFF, 0xFF, 0xFF,  // 13
  0xFF, 0xFF, 0x00, 0x0F, 0x0F, 0x00, 0x07, 0x00, 0x07, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x3A, 0x96, 0x1F, 0xFF, 0xFF, 0xFF,  // 14
  0xFF, 0xFF, 0x0F, 0x07, 0x0F, 0xFE, 0x0F, 0xFE, 0x0F, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x65, 0xD5, 0x0F, 0xFF, 0xFF, 0xFF,  // 15
  0xFF, 0xFF, 0x0F, 0x87, 0x0F, 0xFE, 0x1F, 0xFE, 0x1F, 0xC2, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC8, 0xBA, 0x56, 0xC7, 0xFF, 0xFF, 0xFF,  // 16
  0xFF, 0xFF, 0x0F, 0x87, 0x0F, 0xFC, 0x1F, 0xFC, 0x1F, 0xC2, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xDB, 0x53, 0x53, 0xFF, 0xFF, 0xFF,  // 17
  0xFF, 0xFF, 0x0F, 0x87, 0x0F, 0xF8, 0x3F, 0xF8, 0x3F, 0xC2, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0x59, 0xDC, 0xA0, 0xFF, 0xFF, 0xFF,  // 18
  0xFF, 0xFF, 0x0F, 0x87, 0x0F, 0xF8, 0x3F, 0xF8, 0x3F, 0xC6, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x02, 0x16, 0x52, 0xD4, 0x7F, 0xFF, 0xFF,  // 19
  0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0xF0, 0x7F, 0xF0, 0x7F, 0x87, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x4B, 0x4B, 0x5D, 0x6A, 0x3F, 0xFF, 0xFF,  // 20
  0xFF, 0xFF, 0x00, 0x0F, 0x0F, 0xF0, 0xFF, 0xF0, 0xFF, 0x87, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x8D, 0x6A, 0xD6, 0xAF, 0x1F, 0xFF, 0xFF,  // 21
  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xE0, 0xFF, 0xE0, 0xFF, 0x8F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x05, 0xA5, 0x6B, 0x51, 0x0F, 0xFF, 0xFF,  // 22
  0xFF, 0xFF, 0x00, 0x7F, 0x0F, 0xC1, 0xFF, 0xC1, 0xFF, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC2, 0x03, 0x46, 0xDD, 0xB6, 0xC7, 0xFF, 0xFF,  // 23
  0xFF, 0xFF, 0x0F, 0xFF, 0x0F, 0xC1, 0xFF, 0xC1, 0xFF, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x50, 0x0B, 0x56, 0xDB, 0x63, 0xFF, 0xFF,  // 24
  0xFF, 0xFF, 0x0F, 0xFF, 0x0F, 0x83, 0xFF, 0x83, 0xFF, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x44, 0x0F, 0xF6, 0x49, 0x31, 0xFF, 0xFF,  // 25
  0xFF, 0xFF, 0x0F, 0xFF, 0x0F, 0x87, 0xFF, 0x87, 0xFE, 0x0F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x09, 0x20, 0x98, 0x0D, 0xB6, 0xC8, 0xFF, 0xFF,  // 26
  0xFF, 0xFF, 0x0F, 0xFF, 0x0F, 0x07, 0xFF, 0x07, 0xFE, 0x1F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x02, 0xC8, 0x2C, 0x03, 0x4A, 0xB4, 0x7F, 0xFF,  // 27
  0xFF, 0xFF, 0x0F, 0xFF, 0x0E, 0x00, 0x06, 0x00, 0x06, 0x1F, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x83, 0x6E, 0xF6, 0x39, 0x6B, 0xAA, 0x7F, 0xFF,  // 28
  0xFF, 0xFF, 0x0F, 0xFF, 0x0E, 0x00, 0x06, 0x00, 0x06, 0x1F, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xD5, 0xA1, 0x5B, 0x9C, 0xA8, 0xDD, 0x3F, 0xFF,  // 29
  0xFF, 0xFF, 0x0F, 0xFF, 0x0E, 0x00, 0x06, 0x00, 0x04, 0x1F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC6, 0xCD, 0x08, 0x2E, 0x8E, 0xDF, 0x25, 0x1F, 0xFF,  // 30
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xA3, 0x3F, 0x8B, 0xE6, 0x6A, 0xB5, 0x0F, 0xFF,  // 31
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0xE2, 0x60, 0xE2, 0xA4, 0xB7, 0xD5, 0x87, 0xFF,  // 32
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x2F, 0x02, 0x00, 0x32, 0xE0, 0x55, 0x55, 0xA3, 0xFF,  // 33
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xF0, 0x1E, 0x1E, 0x0B, 0x10, 0xFD, 0x5A, 0xA3, 0xFF,  // 34
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x40, 0x54, 0x21, 0xC9, 0xAA, 0x2A, 0xD5, 0x59, 0xFF,  // 35
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x0B, 0xDE, 0x90, 0x62, 0xA2, 0x2E, 0x55, 0x68, 0xFF,  // 36
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF8, 0xFF, 0x04, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x28, 0x6A, 0x46, 0x13, 0x24, 0x93, 0x5A, 0x94, 0xFF,  // 37
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEE, 0xF0, 0x7E, 0x04, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0xC0, 0x2A, 0x10, 0x01, 0xA1, 0x4B, 0xAB, 0x6A, 0x7F,  // 38
  0xFF, 0xFF, 0xFF, 0xC6, 0x8C, 0x70, 0xEE, 0xE7, 0x3E, 0x7C, 0x9F, 0xFF, 0xFF, 0xFF, 0xFE, 0x21, 0x4B, 0x8D, 0x28, 0x02, 0xD2, 0xB5, 0x76, 0x56, 0x3F,  // 39
  0xFF, 0xFF, 0xFF, 0xBE, 0x73, 0xBF, 0x6E, 0xE7, 0x3E, 0x1C, 0x9F, 0xFF, 0xFF, 0xFF, 0xFC, 0x41, 0xCD, 0x4E, 0x07, 0xE0, 0x2C, 0x05, 0x5B, 0x59, 0x3F,  // 40
  0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0xBC, 0x6E, 0xE7, 0x3E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1A, 0x97, 0x44, 0xE0, 0x0C, 0x64, 0x21, 0xAB, 0x4D, 0x1F,  // 41
  0xFF, 0xFF, 0xFF, 0xCE, 0xF7, 0xB3, 0x6E, 0xF0, 0x3F, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x49, 0x89, 0xCA, 0x30, 0x36, 0x5C, 0xD4, 0x6D, 0xB4, 0x0F,  // 42
  0xFF, 0xFF, 0xFF, 0xF6, 0xF7, 0xB7, 0x6E, 0xFB, 0x3F, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x4A, 0x86, 0x4E, 0x0F, 0xD8, 0x79, 0xB4, 0x9E, 0x60, 0x0F,  // 43
  0xFF, 0xFF, 0xFF, 0xF6, 0xF7, 0xB6, 0x6E, 0xFE, 0x67, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0x84, 0xE3, 0xA3, 0x85, 0x06, 0xF1, 0x48, 0xD6, 0x65, 0x81, 0xCF,  // 44
  0xFF, 0xFF, 0xFF, 0x8E, 0xF7, 0xB9, 0x6E, 0xF0, 0x66, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0xA1, 0x90, 0x15, 0xA1, 0x87, 0x78, 0x00, 0x3C, 0x0F, 0xCF,  // 45
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xE6, 0x1F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20, 0x02, 0x84, 0x92, 0x50, 0x15, 0xC0, 0x00, 0x50, 0x3F, 0xCF,  // 46
  0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x13, 0x40, 0x2A, 0xA4, 0x08, 0x7A, 0xFE, 0xA0, 0x7B, 0x4F,  // 47
  0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xF0, 0x8E, 0xCD, 0xB0, 0x2A, 0x9B, 0x6F, 0x30, 0x20, 0x03, 0xDF, 0xCF,  // 48
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x40, 0x0E, 0xD5, 0x2A, 0xC8, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x1F,  // 49
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0x20, 0x25, 0xEA, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFE, 0xF7, 0x9F,  // 50
  0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x82, 0xD6, 0xD0, 0x00, 0x00, 0x01, 0x4A, 0xFB, 0xFB, 0xFB, 0xBE, 0x3F,  // 51
  0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x4D, 0xFF, 0xFF, 0xFF, 0xFD, 0x7F, 0xE0, 0x7F,  // 52
  0xFF, 0xFF, 0xFF, 0xFF, 0x23, 0xF1, 0xBB, 0xE3, 0xCF, 0x8F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x15, 0xBF, 0xFF, 0xFF, 0xFF, 0xF7, 0xEF, 0xDF, 0x00, 0xFF,  // 53
  0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xEF, 0xBB, 0xDF, 0xB7, 0x7F, 0xFF, 0xFF, 0xFF, 0x2A, 0xFF, 0xBF, 0xFE, 0xFF, 0xEF, 0xFE, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF,  // 54
  0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xEF, 0xBB, 0xBF, 0x7B, 0x7F, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xBF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF,  // 55
  0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xF3, 0xBB, 0xBF, 0x03, 0x9F, 0xFF, 0xFF, 0xFF, 0x3E, 0xFB, 0xF7, 0xEF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFF,  // 56
  0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xFD, 0xBB, 0xBF, 0x7F, 0xEF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFE, 0xFD, 0xFF, 0xF0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF,  // 57
  0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFD, 0xBB, 0xDF, 0xBF, 0xEF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF,  // 58
  0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0xE3, 0xBB, 0xE3, 0xC3, 0x1F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 59
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 60
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 61
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 62
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 63
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 64
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 65
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 66
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 67
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 68
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 69
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 70
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 71
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 72
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x0E, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 73
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x08, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 74
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 75
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x01, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 76
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFF, 0x07, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 77
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFE, 0x0F, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 78
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFE, 0x0F, 0xFE, 0x1F, 0x9F, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF,  // 79
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFE, 0x1F, 0xFE, 0x1F, 0x7F, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF,  // 80
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xFE, 0x1F, 0xFE, 0x1F, 0x7F, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF,  // 81
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0xDF, 0x1F, 0xFE, 0x1F, 0x7F, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF,  // 82
  0xFE, 0x58, 0xD3, 0x1B, 0xA7, 0x1D, 0x27, 0xAC, 0x84, 0xB0, 0xD3, 0x8A, 0x7F, 0xFF, 0xFF, 0x9F, 0x0F, 0xFE, 0x1E, 0x1C, 0xF5, 0xF0, 0xEE, 0xFF, 0xFF,  // 83
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0xFE, 0x1F, 0x7B, 0x73, 0xFF, 0x6E, 0xFF, 0xFF,  // 84
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x0F, 0xFE, 0x1F, 0x77, 0xB7, 0xFC, 0x6E, 0xFF, 0xFF,  // 85
  0xFF, 0xFF, 0xFF, 0x78, 0xE3, 0xEE, 0x18, 0xC1, 0x8E, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x07, 0xFC, 0x3F, 0x77, 0xB7, 0xF3, 0x6E, 0xFF, 0xFF,  // 86
  0xFF, 0xFF, 0xFE, 0x77, 0x5D, 0xCE, 0xF7, 0x7B, 0x75, 0xD7, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0x87, 0xFC, 0x3F, 0x77, 0xB7, 0xF7, 0x6E, 0xFF, 0xFF,  // 87
  0xFF, 0xFF, 0xFD, 0x7F, 0x7D, 0xAD, 0xF7, 0xFB, 0x75, 0xD7, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3, 0xF8, 0x7F, 0x7B, 0x77, 0xF6, 0x6E, 0xFF, 0xFF,  // 88
  0xFF, 0xFF, 0xFF, 0x7F, 0x73, 0xAC, 0x30, 0xF7, 0x8D, 0xD7, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC0, 0x00, 0x7F, 0x7C, 0xF7, 0xF9, 0x6E, 0xFF, 0xFF,  // 89
  0xFF, 0xFF, 0xFF, 0x7E, 0xFD, 0x6F, 0xD7, 0x77, 0x76, 0x17, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0xE0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 90
  0xFF, 0xFF, 0xFF, 0x7D, 0xFD, 0x07, 0xD7, 0x6F, 0x77, 0xD7, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xF8, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 91
  0xFF, 0xFF, 0xFF, 0x7B, 0xDD, 0xED, 0xD7, 0x6F, 0x75, 0xD7, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 92
  0xFF, 0xFF, 0xFF, 0x70, 0x63, 0xEE, 0x38, 0xEF, 0x8E, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 93
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 94
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 95
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 96
};


#elif(USE_EPD_Type==USE_EPD270)

#define image_width_270 264 /**< The resolution of 2 inch is 264*176 */
#define image_height_270 176 /**< the image array size of 2.7 inch is 176*33 where 33=264/8 */
unsigned char const image_array_270_1[] = {
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
		  0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
		  0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
		  0xFF, 0xFF, 0x00, 0x1F, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
		  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xC0, 0xCF, 0xCF, 0xF0, 0x00, 0x3F,  // 12
		  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xC0, 0xCF, 0xCF, 0xF0, 0x00, 0x3F,  // 13
		  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xFC, 0x0F, 0xC3, 0x33, 0xFF, 0x3F,  // 14
		  0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xFC, 0x0F, 0xC3, 0x33, 0xFF, 0x3F,  // 15
		  0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xF0, 0x3F, 0xF3, 0x03, 0x3F,  // 16
		  0xFF, 0xFF, 0x00, 0x06, 0x18, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xF0, 0x3F, 0xF3, 0x03, 0x3F,  // 17
		  0xFF, 0xFF, 0x00, 0x06, 0x18, 0x07, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x30, 0xC3, 0xCC, 0x33, 0x03, 0x3F,  // 18
		  0xFF, 0xFF, 0x00, 0x06, 0x18, 0x07, 0xFF, 0x73, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x30, 0xC3, 0xCC, 0x33, 0x03, 0x3F,  // 19
		  0xFF, 0xFF, 0x00, 0x04, 0x10, 0x07, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x33, 0x0F, 0x3C, 0x33, 0x03, 0x3F,  // 20
		  0xFF, 0xFF, 0x00, 0x0C, 0x30, 0x07, 0xFF, 0xF3, 0x01, 0x8E, 0x79, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x33, 0x0F, 0x3C, 0x33, 0x03, 0x3F,  // 21
		  0xFF, 0xFF, 0x00, 0x3C, 0x3C, 0x07, 0xFF, 0xF3, 0x9F, 0xC6, 0xF0, 0xF1, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xC3, 0xC3, 0x33, 0xF3, 0xFF, 0x3F,  // 22
		  0xFF, 0xFF, 0x00, 0x7C, 0x3E, 0x03, 0xFF, 0xF3, 0x9F, 0xE1, 0xF4, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xC3, 0xC3, 0x33, 0xF3, 0xFF, 0x3F,  // 23
		  0xFF, 0xFF, 0x00, 0x7C, 0x3E, 0x03, 0xFF, 0xF3, 0x9F, 0xF1, 0xF6, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x33, 0x33, 0x33, 0x30, 0x00, 0x3F,  // 24
		  0xF0, 0x00, 0x00, 0x78, 0x3C, 0x03, 0xFF, 0xF3, 0x81, 0xF1, 0xE6, 0x78, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x33, 0x33, 0x33, 0x30, 0x00, 0x3F,  // 25
		  0xF0, 0x00, 0x00, 0x78, 0x7C, 0x01, 0xFF, 0xF3, 0x9F, 0xE0, 0xE0, 0x7F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x33, 0xF3, 0x3F, 0xFF, 0xFF,  // 26
		  0xF8, 0x00, 0x00, 0x18, 0x60, 0x00, 0xFF, 0xF3, 0x9F, 0xEC, 0xCE, 0x3F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x33, 0xF3, 0x3F, 0xFF, 0xFF,  // 27
		  0xF8, 0x00, 0x00, 0x18, 0x60, 0x00, 0xFF, 0xF3, 0x9D, 0xCC, 0x4F, 0x33, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xC0, 0xC3, 0x03, 0xCF, 0xFF, 0x0F, 0xFF,  // 28
		  0xFC, 0x00, 0x00, 0x18, 0x60, 0x00, 0xFF, 0xF3, 0x81, 0x9E, 0x1F, 0x18, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xC0, 0xC3, 0x03, 0xCF, 0xFF, 0x0F, 0xFF,  // 29
		  0xFF, 0x00, 0x00, 0x18, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x33, 0xCC, 0xF3, 0xF0, 0xC0, 0xFC, 0x30, 0xFF,  // 30
		  0xFF, 0x00, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x33, 0xCC, 0xF3, 0xF0, 0xC0, 0xFC, 0x30, 0xFF,  // 31
		  0xFF, 0x80, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0x0C, 0x30, 0x3F, 0x3F, 0x3F, 0xFF,  // 32
		  0xFF, 0xC0, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0x0C, 0x30, 0x3F, 0x3F, 0x3F, 0xFF,  // 33
		  0xFF, 0xC0, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xF3, 0x3E, 0x61, 0xC0, 0xC0, 0xE7, 0xD9, 0xF9, 0x80, 0x8F, 0x30, 0x38, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x3F, 0xF0, 0xF0, 0xF3, 0x0F, 0x3F, 0xFF,  // 34
		  0xFF, 0xE0, 0x00, 0x3F, 0xF0, 0x00, 0xFF, 0xF3, 0x9E, 0xC6, 0xB3, 0x4E, 0x67, 0xD8, 0xF1, 0xCF, 0xC7, 0x6C, 0xD1, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x3F, 0xF0, 0xF0, 0xF3, 0x0F, 0x3F, 0xFF,  // 35
		  0xFF, 0xE0, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0xF3, 0x8E, 0xCF, 0xF3, 0xCF, 0x27, 0xD8, 0xF1, 0xCF, 0xC3, 0x7C, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0xC0, 0xC3, 0xFF, 0x3C, 0x33, 0xFF, 0x3F,  // 36
		  0xFF, 0xF0, 0xF8, 0x7F, 0xF0, 0x1F, 0xFF, 0xF3, 0xA6, 0xCF, 0xF3, 0xCF, 0x27, 0xD8, 0x61, 0xCF, 0xD3, 0x7C, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0xC0, 0xC3, 0xFF, 0x3C, 0x33, 0xFF, 0x3F,  // 37
		  0xFF, 0xF9, 0xFC, 0x7F, 0xF0, 0x7F, 0xFF, 0xF3, 0xB2, 0xE1, 0xF3, 0xC0, 0x67, 0xD9, 0x69, 0xC0, 0xD9, 0x7C, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xCC, 0xF3, 0x00, 0x30, 0x00, 0x30, 0x3F,  // 38
		  0xFF, 0xFF, 0xFC, 0x3F, 0xE1, 0xFF, 0xFF, 0xF3, 0xB0, 0xFC, 0xF3, 0xCC, 0xE7, 0xD9, 0x09, 0xCF, 0xDC, 0x7C, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xCC, 0xF3, 0x00, 0x30, 0x00, 0x30, 0x3F,  // 39
		  0xFF, 0xFF, 0xFE, 0x00, 0x03, 0xFF, 0xFF, 0xF3, 0xB8, 0xFE, 0xF3, 0xCE, 0x67, 0xD9, 0x99, 0xCF, 0xDE, 0x7C, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x30, 0x03, 0xFC, 0x33, 0xCF, 0xF3, 0xFF,  // 40
		  0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xF3, 0xBC, 0xCC, 0xF3, 0xCF, 0x33, 0x99, 0x99, 0xCF, 0xDF, 0x7C, 0xF3, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x30, 0x03, 0xFC, 0x33, 0xCF, 0xF3, 0xFF,  // 41
		  0xFF, 0xFF, 0xFF, 0x00, 0x07, 0xFF, 0xFF, 0xE1, 0x3E, 0xE1, 0xF3, 0xC7, 0x90, 0x39, 0xF9, 0xC0, 0x9F, 0x7C, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xCF, 0xCF, 0x30, 0xFC, 0xFC, 0xF3, 0x3F,  // 42
		  0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xCF, 0xCF, 0x30, 0xFC, 0xFC, 0xF3, 0x3F,  // 43
		  0xFF, 0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0x03, 0x03, 0xCF, 0x3F, 0xF3, 0xFF,  // 44
		  0xFF, 0xFF, 0xFF, 0x80, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0x03, 0x03, 0xCF, 0x3F, 0xF3, 0xFF,  // 45
		  0xFF, 0xFF, 0xFF, 0xC0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0F, 0x03, 0xF0, 0xCC, 0x03, 0x00, 0x3F,  // 46
		  0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0F, 0x03, 0xF0, 0xCC, 0x03, 0x00, 0x3F,  // 47
		  0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x33, 0xF3, 0x0C, 0xC0, 0xF3, 0xFF, 0x3F,  // 48
		  0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x33, 0xF3, 0x0C, 0xC0, 0xF3, 0xFF, 0x3F,  // 49
		  0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCC, 0xF0, 0xFF, 0x3F, 0xF0, 0x3F, 0xFF,  // 50
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCC, 0xF0, 0xFF, 0x3F, 0xF0, 0x3F, 0xFF,  // 51
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x33, 0xF0, 0x33, 0xCC, 0x00, 0x30, 0x3F,  // 52
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x33, 0xF0, 0x33, 0xCC, 0x00, 0x30, 0x3F,  // 53
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x0C, 0xFF, 0x3F, 0x0F, 0xFF,  // 54
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x0C, 0xFF, 0x3F, 0x0F, 0xFF,  // 55
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x3F, 0x00, 0x00, 0x33, 0x03, 0xFF,  // 56
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x3F, 0x00, 0x00, 0x33, 0x03, 0xFF,  // 57
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0x03, 0xF0, 0x3C, 0x3F, 0x0C, 0xFF,  // 58
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0x03, 0xF0, 0x3C, 0x3F, 0x0C, 0xFF,  // 59
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xFF, 0x30, 0x00, 0x3F, 0xFF,  // 60
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xFF, 0x30, 0x00, 0x3F, 0xFF,  // 61
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xF0, 0xCC, 0x00, 0x0C, 0xCF, 0x3F,  // 62
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xF0, 0xCC, 0x00, 0x0C, 0xCF, 0x3F,  // 63
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xCF, 0xCC, 0x0F, 0xC0, 0x00, 0xFF,  // 64
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x07, 0xFF, 0xFF, 0x30, 0x33, 0xCF, 0xCC, 0x0F, 0xC0, 0x00, 0xFF,  // 65
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x3F, 0xF3, 0x0F, 0x3C, 0x30, 0xF0, 0xC3, 0x3F,  // 66
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x3F, 0xF3, 0x0F, 0x3C, 0x30, 0xF0, 0xC3, 0x3F,  // 67
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x03, 0x30, 0x00, 0xCC, 0xFC, 0x03, 0xFF,  // 68
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 0x00, 0x03, 0x30, 0x00, 0xCC, 0xFC, 0x03, 0xFF,  // 69
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 70
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 71
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 72
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xE0, 0x30, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 73
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 74
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0xF8, 0x00, 0x20, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 75
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xC0, 0x01, 0xF0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 76
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 77
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x07, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 78
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x0F, 0xF8, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0x03, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 79
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xE0, 0x03, 0xFF, 0xFC, 0x00, 0x00, 0x03, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 80
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0x80, 0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 81
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 82
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 83
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xF8, 0xFF, 0x00, 0x00, 0x01, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 84
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 85
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFE, 0x00, 0x7F, 0x80, 0x00, 0x01, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 86
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xF8, 0xFF, 0xF0, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 87
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xF8, 0xFF, 0xC0, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 88
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 89
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xE0, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 90
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xF1, 0xFC, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 91
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x01, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 92
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFE, 0x00, 0x0F, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 93
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 94
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 95
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 96
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0x80, 0x3E, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 97
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0x83, 0xFF, 0x3F, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 98
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 99
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 100
		  0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 101
		  0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 102
		  0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x80, 0x00, 0x1C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 103
		  0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xC4, 0x3F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 104
		  0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0x3F, 0xC7, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 105
		  0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFE, 0x3F, 0xC7, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 106
		  0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xF8, 0x7F, 0xC7, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 107
		  0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF, 0xC7, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 108
		  0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xE3, 0xFF, 0x8F, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 109
		  0xFF, 0xFF, 0xF8, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0x8F, 0xFF, 0x0F, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 110
		  0xFF, 0xFF, 0xE1, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0x1F, 0xFE, 0x1F, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 111
		  0xFF, 0xFF, 0xC7, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFC, 0x7F, 0xFC, 0x3E, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 112
		  0xFF, 0xFF, 0x8F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xF0, 0xFF, 0xF0, 0x60, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 113
		  0xFF, 0xFE, 0x3F, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xE1, 0xFF, 0xC0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 114
		  0xFF, 0xFC, 0x7F, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x87, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 115
		  0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0x1F, 0xFE, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 116
		  0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFC, 0x3F, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 117
		  0xFF, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 118
		  0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x47, 0x0F, 0xFF,  // 119
		  0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xC7, 0x0F, 0xFF,  // 120
		  0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x96, 0x4F, 0xFF,  // 121
		  0xFC, 0x7F, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3C, 0x1E, 0x0F, 0x80, 0x7F, 0xCF, 0x0F, 0xE3, 0xF3, 0x96, 0x1F, 0xFF,  // 122
		  0xF8, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3C, 0x1C, 0x07, 0x80, 0x1F, 0x8E, 0x07, 0x81, 0xF3, 0x94, 0x9F, 0xFF,  // 123
		  0xF8, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x98, 0x18, 0xE3, 0x8F, 0x1F, 0x0C, 0x63, 0x98, 0xF3, 0x94, 0x9F, 0xFF,  // 124
		  0xFC, 0x00, 0x00, 0x7F, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x99, 0x19, 0xF3, 0x1F, 0x1E, 0x1C, 0xE3, 0x18, 0xF3, 0x91, 0x9F, 0xFF,  // 125
		  0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xF8, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x99, 0x38, 0xFF, 0x1F, 0x1C, 0x1F, 0xC3, 0x18, 0xE7, 0x31, 0x3F, 0xFF,  // 126
		  0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x92, 0x38, 0x3F, 0x1E, 0x39, 0x1F, 0x06, 0x38, 0xE7, 0x33, 0x3F, 0xFF,  // 127
		  0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x92, 0x3C, 0x0F, 0x00, 0x33, 0x1F, 0x0E, 0x38, 0xFF, 0xFF, 0xFF, 0xFF,  // 128
		  0xFF, 0xFF, 0xFF, 0xFC, 0x7E, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x92, 0x3F, 0x07, 0x00, 0xE7, 0x1F, 0xC6, 0x38, 0xFF, 0xFF, 0xFF, 0xFF,  // 129
		  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x86, 0x3F, 0xC7, 0x1F, 0xC0, 0x0F, 0xC6, 0x31, 0xFF, 0xFF, 0xFF, 0xFF,  // 130
		  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x86, 0x27, 0xE7, 0x1F, 0xC0, 0x09, 0xC6, 0x31, 0xFF, 0xFF, 0xFF, 0xFF,  // 131
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C, 0x63, 0xC6, 0x3F, 0xFE, 0x38, 0x86, 0x33, 0xFF, 0xFF, 0xFF, 0xFF,  // 132
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C, 0x70, 0x0E, 0x3F, 0xFE, 0x3C, 0x0F, 0x03, 0xFF, 0xFF, 0xFF, 0xFF,  // 133
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x9C, 0x78, 0x1E, 0x3F, 0xFE, 0x3E, 0x1F, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF,  // 134
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 135
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 136
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 137
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 138
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 139
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 140
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 141
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 142
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 143
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 144
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF,  // 145
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 146
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 147
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 148
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFC, 0x1C, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 149
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xF8, 0x1F, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 150
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xF8, 0x3F, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 151
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0x03, 0x87, 0xE1, 0xFC, 0x1F, 0x8F, 0x03, 0xFF, 0xC0, 0x7E, 0x0C, 0x0F, 0xF8, 0x3F, 0x81, 0xF8, 0x1C, 0x3F, 0xE0, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 152
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFC, 0x01, 0x87, 0xC1, 0xFC, 0x1F, 0x0C, 0x01, 0xFF, 0x00, 0x1E, 0x08, 0x07, 0xF8, 0x3F, 0x81, 0xE0, 0x04, 0x3F, 0x80, 0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 153
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xF8, 0x00, 0x07, 0xC1, 0xFC, 0x1F, 0x08, 0x01, 0xFE, 0x00, 0x1E, 0x00, 0x03, 0xF8, 0x3F, 0x83, 0xC0, 0x00, 0x3F, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 154
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xF0, 0x00, 0x07, 0xC1, 0xF8, 0x3F, 0x00, 0x00, 0xFC, 0x00, 0x1C, 0x00, 0x03, 0xF0, 0x3F, 0x83, 0xC0, 0x00, 0x3E, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 155
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xF0, 0x3C, 0x0F, 0xC3, 0xF8, 0x3F, 0x01, 0xC0, 0xF8, 0x1F, 0x3C, 0x03, 0x83, 0xF0, 0x7F, 0x03, 0x81, 0xE0, 0x3E, 0x07, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 156
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE0, 0x7E, 0x0F, 0x83, 0xF8, 0x3E, 0x03, 0xE0, 0xF8, 0x3F, 0xFC, 0x07, 0x83, 0xF0, 0x7E, 0x07, 0x03, 0xF0, 0x7C, 0x0F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 157
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0x0F, 0x83, 0xF8, 0x3E, 0x07, 0xE0, 0xF0, 0x7F, 0xFC, 0x0F, 0x83, 0xF0, 0x00, 0x0F, 0x07, 0xF0, 0x7C, 0x1F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 158
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xC0, 0xFE, 0x0F, 0x83, 0xF8, 0x3E, 0x0F, 0xE1, 0xF0, 0x7F, 0xFC, 0x1F, 0x83, 0xF0, 0x00, 0x1F, 0x07, 0xF0, 0x78, 0x1F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 159
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xC1, 0xFE, 0x0F, 0x83, 0xF0, 0x7E, 0x0F, 0xC1, 0xE0, 0x7F, 0xF8, 0x1F, 0x83, 0xE0, 0x00, 0x3E, 0x0F, 0xF0, 0x78, 0x3F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 160
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xC1, 0xFC, 0x1F, 0x83, 0xF0, 0x7E, 0x1F, 0xC1, 0xE0, 0xFF, 0xF8, 0x3F, 0x83, 0xE0, 0x00, 0xFE, 0x0F, 0xF0, 0x78, 0x3F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 161
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0x81, 0xFC, 0x1F, 0x07, 0xF0, 0x7C, 0x1F, 0xC1, 0xE0, 0xFF, 0xF8, 0x3F, 0x83, 0xE0, 0xFF, 0xFE, 0x0F, 0xE0, 0xF8, 0x3F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 162
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0x81, 0xFC, 0x1F, 0x07, 0xE0, 0x7C, 0x1F, 0xC1, 0xE0, 0xFF, 0xF8, 0x3F, 0x07, 0xE0, 0xFF, 0xFE, 0x0F, 0xE0, 0xF0, 0x3F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 163
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0x81, 0xF8, 0x1F, 0x07, 0xE0, 0x7C, 0x1F, 0xC3, 0xE0, 0xFF, 0xF8, 0x7F, 0x07, 0xE0, 0xFF, 0xFE, 0x0F, 0xC0, 0xF0, 0x3F, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 164
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0x81, 0xF0, 0x1F, 0x07, 0xC0, 0xFC, 0x1F, 0x83, 0xE0, 0xFF, 0xF0, 0x7F, 0x07, 0xC0, 0xFF, 0xFE, 0x0F, 0xC0, 0xF0, 0x3E, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 165
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0x81, 0xF0, 0x3F, 0x07, 0x80, 0xFC, 0x3F, 0x83, 0xE0, 0xFE, 0xF0, 0x7F, 0x07, 0xC1, 0xFF, 0xFE, 0x0F, 0x80, 0xF0, 0x3C, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 166
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0x80, 0xC0, 0x3F, 0x02, 0x00, 0xF8, 0x3F, 0x83, 0xE0, 0x78, 0xF0, 0x7F, 0x07, 0xC1, 0xFF, 0xFE, 0x06, 0x01, 0xF8, 0x18, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 167
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0x80, 0x00, 0x3F, 0x00, 0x00, 0xF8, 0x3F, 0x83, 0xE0, 0x00, 0xF0, 0x7E, 0x0F, 0x81, 0xFF, 0xFE, 0x00, 0x01, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 168
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xC0, 0x0C, 0x3F, 0x00, 0x30, 0xF8, 0x3F, 0x07, 0xF0, 0x00, 0xE0, 0xFE, 0x0F, 0x81, 0xFF, 0xFF, 0x00, 0x21, 0xF8, 0x01, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 169
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xE0, 0x18, 0x3F, 0x80, 0x70, 0xF8, 0x3F, 0x07, 0xF8, 0x01, 0xE0, 0xFE, 0x0F, 0x83, 0xFF, 0xFF, 0x00, 0xC1, 0xFC, 0x03, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 170
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xF8, 0x7C, 0x7F, 0xC1, 0xF1, 0xF8, 0x7F, 0x0F, 0xFE, 0x0F, 0xF1, 0xFF, 0x1F, 0xC7, 0xFF, 0xFF, 0xC3, 0xE3, 0xFF, 0x0F, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 171
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 172
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 173
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 174
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 175
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 176
		};

unsigned char const image_array_270_2[] = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 12
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 13
  0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x18, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 14
  0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x7E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 15
  0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFC, 0x3F, 0xFF, 0xC3, 0xFF, 0xE0, 0x7E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 16
  0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFE, 0x7F, 0xFF, 0xC3, 0xFF, 0xC0, 0x7E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 17
  0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xC0, 0x3E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0x87, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 18
  0xFF, 0xF8, 0x3F, 0xFE, 0x0F, 0x87, 0xE0, 0xFC, 0x67, 0xF0, 0xE3, 0x0F, 0x87, 0x1E, 0x3F, 0x0F, 0xC0, 0xFF, 0xC4, 0x3E, 0x18, 0x7F, 0xF0, 0xE3, 0x0F, 0xFF, 0x07, 0xC1, 0xC6, 0x1F, 0xE1, 0xFF, 0xFF,  // 19
  0xFF, 0xF8, 0x7F, 0xF8, 0x03, 0x87, 0x80, 0x3C, 0x47, 0xF0, 0xE0, 0x07, 0x86, 0x1C, 0x3C, 0x03, 0x00, 0xFF, 0xC4, 0x3E, 0x18, 0x7F, 0xF0, 0xE0, 0x07, 0xFF, 0x0F, 0xE1, 0xC0, 0x0F, 0x80, 0x7F, 0xFF,  // 20
  0xFF, 0xF8, 0x7F, 0xF0, 0x03, 0x87, 0x00, 0x3C, 0x07, 0xF0, 0xE0, 0x03, 0x84, 0x1C, 0x38, 0x01, 0x00, 0xFF, 0x86, 0x3E, 0x18, 0x7F, 0xF0, 0xE0, 0x03, 0xFF, 0x0F, 0xE1, 0xC0, 0x07, 0x00, 0x3F, 0xFF,  // 21
  0xFF, 0xF8, 0x7F, 0xF0, 0xE1, 0x87, 0x0E, 0x1C, 0x07, 0xF0, 0xE0, 0x83, 0x84, 0x3C, 0x38, 0xE1, 0xC3, 0xFF, 0x86, 0x1E, 0x18, 0x7F, 0xF0, 0xE0, 0x83, 0xFF, 0x0F, 0xE1, 0xC1, 0x07, 0x1C, 0x3F, 0xFF,  // 22
  0xFF, 0xF8, 0x7F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x1F, 0xF0, 0xE1, 0xC3, 0x80, 0x7C, 0x30, 0xF1, 0xC3, 0xFF, 0x8E, 0x1E, 0x18, 0x60, 0x70, 0xE1, 0xC3, 0x03, 0x0F, 0xE1, 0xC3, 0x86, 0x1E, 0x3F, 0xFF,  // 23
  0xFF, 0xF8, 0x7F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x3F, 0xF0, 0xE1, 0xC3, 0x80, 0x7C, 0x30, 0x00, 0xC3, 0xFF, 0x00, 0x1E, 0x18, 0x60, 0x30, 0xE1, 0xC3, 0x01, 0x0F, 0xE1, 0xC3, 0x86, 0x00, 0x1F, 0xFF,  // 24
  0xFF, 0xF8, 0x7F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x3F, 0xF0, 0xE1, 0xC3, 0x80, 0x7C, 0x30, 0x00, 0xC3, 0xFF, 0x00, 0x0E, 0x18, 0x60, 0x30, 0xE1, 0xC3, 0x01, 0x0F, 0xE1, 0xC3, 0x86, 0x00, 0x1F, 0xFF,  // 25
  0xFF, 0xF8, 0x3F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x3F, 0xF0, 0xE1, 0xC3, 0x80, 0x3C, 0x30, 0xFF, 0xC3, 0xFF, 0x00, 0x0E, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0x07, 0xC1, 0xC3, 0x86, 0x1F, 0xFF, 0xFF,  // 26
  0xFF, 0xFC, 0x1F, 0xF0, 0xE1, 0x87, 0x0E, 0x1C, 0x3F, 0xF0, 0xE1, 0xC3, 0x84, 0x1C, 0x30, 0xFF, 0xC3, 0xFE, 0x1F, 0x0E, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0x83, 0x83, 0xC3, 0x86, 0x1F, 0xFF, 0xFF,  // 27
  0xFF, 0xFE, 0x00, 0x70, 0x01, 0x87, 0x00, 0x1C, 0x3F, 0xF0, 0xE1, 0xC3, 0x86, 0x1C, 0x38, 0x01, 0xC0, 0xFE, 0x1F, 0x06, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0xC0, 0x03, 0xC3, 0x87, 0x00, 0x3F, 0xFF,  // 28
  0xFF, 0xFF, 0x00, 0x78, 0x03, 0x87, 0x80, 0x3C, 0x3F, 0xF0, 0xE1, 0xC3, 0x86, 0x0C, 0x3C, 0x01, 0xC0, 0xFE, 0x1F, 0x86, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0xC0, 0x07, 0xC3, 0x87, 0x80, 0x3F, 0xFF,  // 29
  0xFF, 0xFF, 0x80, 0x7C, 0x07, 0x87, 0xC0, 0x7C, 0x3F, 0xF0, 0xE1, 0xC3, 0x87, 0x0C, 0x3E, 0x01, 0xE0, 0xFC, 0x1F, 0x86, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0xF0, 0x1F, 0xC3, 0x87, 0xC0, 0x3F, 0xFF,  // 30
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 31
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 32
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 33
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 34
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 35
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 36
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 37
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 38
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 39
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 40
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 41
  0xFF, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x0E, 0x3F, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 42
  0xFF, 0xFC, 0x00, 0xCF, 0x0E, 0x3F, 0xFF, 0xF0, 0x3F, 0x08, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 43
  0xFF, 0x00, 0x3F, 0xE0, 0x00, 0x0F, 0xFF, 0x03, 0xFF, 0xC0, 0x03, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 44
  0xE0, 0x1F, 0xFF, 0xF3, 0xC3, 0xE7, 0xF0, 0x1F, 0xFF, 0xF0, 0x08, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 45
  0xE7, 0xFF, 0xFF, 0xFC, 0xF0, 0xE0, 0x01, 0xFF, 0xFF, 0xFC, 0x7E, 0x31, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 46
  0xE7, 0xFF, 0xFF, 0xFE, 0x38, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x3F, 0x98, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 47
  0xE3, 0xFF, 0xFF, 0xFF, 0x9E, 0x19, 0xCF, 0xFF, 0xFF, 0xFF, 0x8F, 0xE6, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 48
  0xE1, 0xFF, 0xFF, 0xFF, 0xCF, 0x84, 0xE3, 0xFF, 0xFF, 0xFF, 0xE3, 0xF9, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 49
  0xE4, 0x7F, 0xFF, 0xFF, 0xE3, 0xC0, 0x79, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x63, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 50
  0xE7, 0x3F, 0xFF, 0xFF, 0xF9, 0xF0, 0x3C, 0x7F, 0xFF, 0xFF, 0xFE, 0x7F, 0x98, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 51
  0xE7, 0x9F, 0xFF, 0xFF, 0xFC, 0x78, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0x1F, 0xE6, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 52
  0xE7, 0xCF, 0xFF, 0xFF, 0xFF, 0x39, 0xA7, 0x8F, 0xFF, 0xFF, 0xFF, 0xCF, 0xF1, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 53
  0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0x83, 0xD1, 0xE7, 0xFF, 0xFF, 0xFF, 0xEF, 0xFC, 0x63, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 54
  0xE7, 0xF3, 0xFF, 0xFF, 0xFF, 0xE7, 0xEC, 0xF1, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0x18, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 55
  0xE7, 0xF9, 0xFF, 0xFF, 0xFF, 0xF3, 0xF6, 0x3C, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xC4, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 56
  0xE7, 0xFC, 0xFF, 0xFF, 0xFF, 0xF9, 0xFB, 0x9E, 0x3F, 0xFF, 0xFF, 0xC7, 0xFF, 0xF7, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 57
  0xE7, 0xFE, 0x7F, 0xFF, 0xFF, 0xFD, 0xF9, 0xCF, 0x9F, 0xFF, 0xFF, 0x8F, 0xFF, 0xE7, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 58
  0xF7, 0xFF, 0x3F, 0xFF, 0xFF, 0xFE, 0xFC, 0xF0, 0x07, 0xFF, 0xFE, 0x0F, 0xFF, 0xCE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 59
  0xF7, 0xFF, 0x9F, 0xFF, 0xFF, 0xFE, 0x7E, 0x80, 0x01, 0xFF, 0xC0, 0x3F, 0xFC, 0x10, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 60
  0xF3, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0x7E, 0x07, 0xE4, 0xF8, 0x00, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 61
  0xF1, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0x3F, 0x3F, 0xE6, 0x00, 0x0F, 0xE0, 0x00, 0x06, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 62
  0xF0, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xBF, 0xBF, 0xE0, 0x00, 0x7F, 0x00, 0x00, 0x38, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 63
  0xF2, 0x7F, 0xF3, 0xFF, 0xFF, 0xFF, 0x9F, 0x9E, 0x03, 0x07, 0xE0, 0x00, 0x00, 0x02, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0x7F,  // 64
  0xF3, 0x3F, 0xF9, 0xFF, 0xFF, 0xFF, 0xDF, 0xC0, 0x60, 0x7C, 0x00, 0x00, 0x0F, 0xDE, 0x7F, 0xFF, 0xFF, 0xF0, 0x1F, 0xFC, 0x00, 0x00, 0x3F, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0x80, 0x1F,  // 65
  0xF3, 0x9F, 0xFD, 0xFF, 0xF9, 0xFF, 0xDF, 0xE6, 0x0F, 0x80, 0x00, 0x00, 0xCF, 0x4E, 0x7F, 0xFF, 0xFF, 0xC0, 0x1F, 0xF8, 0x00, 0x00, 0x3F, 0x80, 0x01, 0xFF, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0x00, 0x0F,  // 66
  0xF3, 0xCF, 0xFC, 0xFF, 0xE1, 0xFF, 0xCF, 0xF0, 0x70, 0x01, 0x00, 0x1E, 0x07, 0xEE, 0x7F, 0xFF, 0xFF, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x3F, 0x00, 0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x07, 0xFC, 0x00, 0x07,  // 67
  0xF3, 0xE7, 0xFE, 0xFF, 0xED, 0xFF, 0xCF, 0xFC, 0x00, 0xD8, 0x07, 0xC8, 0x0E, 0x06, 0x7F, 0xFF, 0xFE, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x03, 0xF8, 0x00, 0x07,  // 68
  0xF1, 0xF3, 0xFE, 0xFF, 0xE1, 0xFF, 0xCF, 0xFF, 0x0F, 0x00, 0x18, 0x00, 0xF0, 0x86, 0x7F, 0xFF, 0xFC, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x7C, 0x07, 0xE0, 0x7F, 0xFF, 0xE0, 0x3F, 0x03, 0xF8, 0x1E, 0x03,  // 69
  0xF0, 0xF9, 0xFE, 0x7F, 0xC7, 0xFF, 0xCF, 0xFF, 0xE0, 0x00, 0x00, 0x06, 0x00, 0x82, 0xFF, 0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0xFC, 0x0F, 0xE0, 0x7F, 0xFF, 0xE0, 0x7F, 0x03, 0xF0, 0x3F, 0x03,  // 70
  0xFA, 0xFC, 0xFF, 0x7F, 0xFF, 0xFF, 0xEF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x06, 0xC0, 0xFF, 0xFF, 0xFE, 0x30, 0x3F, 0xFF, 0xFF, 0xC1, 0xF8, 0x1F, 0xF0, 0x3F, 0xFF, 0xC0, 0xFF, 0x81, 0xE0, 0x7F, 0x83,  // 71
  0xFA, 0x7F, 0x7F, 0x7F, 0xFF, 0xFF, 0xEF, 0x80, 0x00, 0x07, 0xA8, 0x02, 0x78, 0x40, 0xFF, 0xFF, 0xFE, 0xF0, 0x3F, 0xFF, 0xFF, 0x81, 0xF8, 0x1F, 0xF0, 0x3F, 0xFF, 0xC0, 0xFF, 0x81, 0xE0, 0x7F, 0x81,  // 72
  0xFB, 0x3F, 0xBF, 0x3F, 0xFF, 0xFF, 0xE0, 0x01, 0xE0, 0xBF, 0xC0, 0x01, 0xC0, 0x04, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0x03, 0xF8, 0x1F, 0xF0, 0x3F, 0xFF, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81,  // 73
  0xFB, 0x9F, 0xDF, 0x3F, 0xFF, 0xFF, 0x80, 0x1F, 0xE3, 0xFF, 0x94, 0x01, 0x00, 0xB8, 0xFF, 0xCF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0x03, 0xF0, 0x3F, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0x81, 0xC0, 0xFF, 0x81,  // 74
  0xFB, 0xCF, 0xEF, 0x3F, 0xFF, 0xF0, 0x01, 0xF0, 0xF3, 0xF0, 0x30, 0x00, 0x07, 0x80, 0xFF, 0x9F, 0xFF, 0xF0, 0x7F, 0xFF, 0xFE, 0x07, 0xF0, 0x3F, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0x81, 0xC0, 0xFF, 0x81,  // 75
  0xF9, 0xE7, 0xF7, 0x3F, 0xFF, 0xE4, 0x7E, 0x10, 0x71, 0x02, 0x7A, 0x00, 0xF8, 0x00, 0xFF, 0x8F, 0xFF, 0xE0, 0x7F, 0xFF, 0xFC, 0x0F, 0xF0, 0x3F, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0x81, 0x81, 0xFF, 0x81,  // 76
  0xF8, 0xF3, 0xFB, 0xBF, 0xFF, 0x0C, 0xC2, 0x1F, 0x38, 0x70, 0x22, 0x07, 0x80, 0x3D, 0xFE, 0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xFC, 0x0F, 0xF0, 0x3F, 0xE0, 0x3F, 0xFF, 0x81, 0xFF, 0x01, 0x81, 0xFF, 0x83,  // 77
  0xF8, 0x79, 0xFD, 0xBF, 0xF0, 0x2C, 0xC3, 0xBC, 0x3B, 0xE7, 0xA0, 0x7C, 0x07, 0x7D, 0xF8, 0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xF8, 0x1F, 0xF0, 0x1F, 0xE0, 0x3F, 0xFF, 0x80, 0xFF, 0x01, 0x81, 0xFF, 0x83,  // 78
  0xF9, 0x3C, 0xFE, 0xBF, 0x03, 0xEC, 0x63, 0xF8, 0x39, 0xF2, 0x21, 0xC0, 0x3F, 0x79, 0xF8, 0xFB, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0x3F, 0xF8, 0x1F, 0xC0, 0x7F, 0xFF, 0xC0, 0xFE, 0x03, 0x03, 0xFF, 0x03,  // 79
  0xF9, 0x9E, 0x7F, 0x30, 0x3F, 0xED, 0x7F, 0xF8, 0xFC, 0x30, 0xF0, 0x03, 0x7F, 0x79, 0xF1, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0x3F, 0xF8, 0x06, 0x00, 0x7F, 0xFF, 0xC0, 0x30, 0x03, 0x03, 0xFF, 0x03,  // 80
  0xF9, 0xCF, 0x3F, 0x87, 0xFF, 0xED, 0x7F, 0xFF, 0xC0, 0x03, 0x00, 0x1F, 0x7F, 0x79, 0xF1, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xE0, 0x7F, 0xF8, 0x00, 0x00, 0x7F, 0xFF, 0xC0, 0x00, 0x03, 0x03, 0xFF, 0x03,  // 81
  0xF9, 0xE7, 0x9F, 0xBF, 0xFF, 0xED, 0x3F, 0xFE, 0x02, 0x30, 0x00, 0x3F, 0x7E, 0x79, 0xF1, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, 0x07, 0x03, 0xFF, 0x03,  // 82
  0xF9, 0xF3, 0xCF, 0xBF, 0xFF, 0xED, 0xBF, 0xC2, 0x06, 0x00, 0x00, 0x07, 0x7E, 0x79, 0xF0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFE, 0x00, 0x40, 0xFF, 0xFF, 0xF0, 0x02, 0x07, 0x03, 0xFE, 0x07,  // 83
  0xF9, 0xF9, 0xE7, 0xBF, 0xFF, 0xED, 0x98, 0x52, 0x3E, 0x00, 0x00, 0x00, 0x7E, 0x79, 0xF8, 0x7F, 0xFF, 0xC1, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0x80, 0xC0, 0xFF, 0xFF, 0xFC, 0x06, 0x07, 0x03, 0xFE, 0x07,  // 84
  0xF9, 0xFC, 0xF3, 0x9F, 0xFF, 0xED, 0xDB, 0x47, 0xE0, 0x00, 0x00, 0x18, 0x7E, 0x73, 0xFC, 0x1F, 0xFF, 0xC1, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0x03, 0xFE, 0x07,  // 85
  0xF9, 0xFE, 0xF9, 0xDF, 0xFF, 0xED, 0xC8, 0x7E, 0x00, 0x00, 0x00, 0x0F, 0x7E, 0x73, 0xFE, 0x0F, 0xFF, 0x81, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0x03, 0xFC, 0x0F,  // 86
  0xFD, 0xFE, 0x7C, 0xDF, 0xFF, 0xED, 0xE3, 0xE0, 0x00, 0x00, 0x00, 0x03, 0x7E, 0xF3, 0xFF, 0x8F, 0xFF, 0x81, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0x03, 0xFC, 0x0F,  // 87
  0xFD, 0xFF, 0x3E, 0x5F, 0xFF, 0xE0, 0x78, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x7C, 0xF3, 0xFF, 0xC7, 0xFF, 0x81, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0x03, 0xFC, 0x0F,  // 88
  0xFC, 0xFF, 0x9F, 0x18, 0x3F, 0x87, 0x0C, 0x00, 0x00, 0x03, 0xFF, 0x80, 0x79, 0xC3, 0xFF, 0xC7, 0xFF, 0x83, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xF8, 0x07, 0xF8, 0x7F, 0xFF, 0xC0, 0x3F, 0x03, 0xF8, 0x1F,  // 89
  0xFC, 0xFF, 0xCF, 0x81, 0x9C, 0x0F, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x63, 0x13, 0xFF, 0xC7, 0xFF, 0x83, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xE0, 0x0F, 0xF0, 0x3F, 0xFF, 0x00, 0x7F, 0x01, 0xF0, 0x3F,  // 90
  0xFE, 0xFF, 0xE7, 0xDF, 0xC1, 0xEF, 0xE0, 0x00, 0x03, 0xFF, 0xF8, 0x30, 0x00, 0x73, 0xFF, 0xC7, 0xFF, 0x03, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0x00, 0x1F, 0xE0, 0x3F, 0xF8, 0x00, 0xFF, 0x81, 0xE0, 0x3F,  // 91
  0xFE, 0x7F, 0xF3, 0xDF, 0xDF, 0xEF, 0xE0, 0x00, 0x3F, 0xFF, 0xC0, 0x3C, 0x01, 0xF3, 0xDF, 0x8F, 0xFF, 0x03, 0xFF, 0xF0, 0x3F, 0xFF, 0xF0, 0x00, 0x3F, 0xE0, 0x3F, 0x80, 0x01, 0xFF, 0x80, 0x00, 0x7F,  // 92
  0xFF, 0x3F, 0xF9, 0xDF, 0xDF, 0xEF, 0xE0, 0x03, 0xFF, 0xFC, 0x01, 0xFF, 0x1C, 0x67, 0xC0, 0x0F, 0xFF, 0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xF0, 0x00, 0xFF, 0xE0, 0x3F, 0x80, 0x07, 0xFF, 0xC0, 0x00, 0xFF,  // 93
  0xFF, 0x3F, 0xFD, 0xDF, 0xDF, 0xEF, 0xE0, 0x1F, 0xFF, 0xF8, 0x1F, 0xE7, 0xC7, 0x27, 0xC0, 0x3F, 0xFF, 0x03, 0xFF, 0xC0, 0x7F, 0xFF, 0xF0, 0x01, 0xFF, 0xE0, 0x3F, 0x80, 0x0F, 0xFF, 0xE0, 0x01, 0xFF,  // 94
  0xFF, 0x9F, 0xFE, 0xDF, 0xDF, 0xEF, 0xE1, 0xFF, 0xFE, 0x1E, 0xFF, 0xFD, 0xE1, 0x87, 0xF8, 0xFF, 0xFF, 0x07, 0xFF, 0xC0, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xF0, 0x7F, 0x80, 0x7F, 0xFF, 0xF0, 0x07, 0xFF,  // 95
  0xFF, 0x8F, 0xFE, 0xDF, 0xDF, 0xEF, 0xE7, 0xFF, 0xFC, 0x0F, 0xF7, 0xFF, 0xF8, 0xE7, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0xF9, 0xFF, 0x8F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF,  // 96
  0xFF, 0xCF, 0xFE, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFE, 0x3F, 0x7F, 0xFF, 0xBE, 0x31, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 97
  0xFF, 0xE7, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 98
  0xFF, 0xF3, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFF, 0xFF, 0xDF, 0xEF, 0xEF, 0xC6, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 99
  0xFF, 0xF9, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xF1, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 100
  0xFF, 0xFC, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 101
  0xFF, 0xFE, 0x7F, 0x5F, 0xDF, 0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xBE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 102
  0xFF, 0xFF, 0x3F, 0x5F, 0xDF, 0xF7, 0x87, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 103
  0xFF, 0xFF, 0x9F, 0x5F, 0xDF, 0xF0, 0x23, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 104
  0xFF, 0xFF, 0x8F, 0x5F, 0xCF, 0xFD, 0xE0, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 105
  0xFF, 0xFF, 0xCF, 0x5F, 0xE7, 0xFE, 0x00, 0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFB, 0xFC, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 106
  0xFF, 0xFF, 0xE7, 0x5F, 0xF3, 0xE0, 0x34, 0x1F, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 107
  0xFF, 0xFF, 0xF3, 0x1F, 0xF8, 0x00, 0x16, 0x0F, 0xFF, 0xE3, 0xFF, 0xFD, 0xFE, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 108
  0xFF, 0xFF, 0xF3, 0x1F, 0xFF, 0x03, 0xD7, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 109
  0xFF, 0xFF, 0xF9, 0x1F, 0xF0, 0x3F, 0xD3, 0x80, 0xFF, 0xFC, 0xFF, 0xFF, 0x3F, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 110
  0xFF, 0xFF, 0xFC, 0x1F, 0x80, 0x7F, 0x91, 0xC0, 0x7F, 0xFF, 0xFF, 0xFB, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 111
  0xFF, 0xFF, 0xFE, 0x4F, 0x30, 0xDF, 0x00, 0xE0, 0x1F, 0xFF, 0x9F, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 112
  0xFF, 0xFF, 0xFF, 0x2F, 0x68, 0x10, 0x08, 0x70, 0x8F, 0xFF, 0xF1, 0xFF, 0xFF, 0x81, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 113
  0xFF, 0xFF, 0xFF, 0x0F, 0x40, 0x00, 0xFC, 0x38, 0x63, 0xFF, 0xE7, 0xFF, 0xFC, 0x0F, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 114
  0xFF, 0xFF, 0xFF, 0x8F, 0x00, 0x0F, 0xFE, 0x1C, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE7, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 115
  0xFF, 0xFF, 0xFF, 0xC7, 0x00, 0x7F, 0xFF, 0x06, 0x2C, 0x7F, 0xFF, 0xFF, 0x07, 0xFF, 0xE3, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 116
  0xFF, 0xFF, 0xFF, 0xE0, 0x07, 0xFF, 0xFF, 0x83, 0x1C, 0x3F, 0xFF, 0xF0, 0x3F, 0xFF, 0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 117
  0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xC1, 0x80, 0x0F, 0xFF, 0x81, 0xFF, 0xF8, 0x60, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 118
  0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xE0, 0x8E, 0x03, 0xFC, 0x0F, 0xFF, 0xE3, 0x07, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 119
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x2F, 0x01, 0xE0, 0x7F, 0xFE, 0x10, 0x3C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 120
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xC0, 0x03, 0xFF, 0xF8, 0xE1, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 121
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xC0, 0x13, 0xFF, 0xC3, 0x0F, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 122
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1E, 0x01, 0xF9, 0xFE, 0x00, 0x3C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 123
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xFC, 0xF8, 0xC1, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 124
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0xFE, 0x02, 0x0F, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 125
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 126
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 127
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 128
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x3C, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 129
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 130
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 131
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 132
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 133
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 134
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 135
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 136
  0xFF, 0xFE, 0x0E, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x8F, 0xFF, 0xFF, 0xFF, 0x83, 0xCE, 0xBF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0x3F, 0x8F, 0x86, 0xBD, 0xF8, 0x60, 0xFF,  // 137
  0xFF, 0xFE, 0xF7, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x7F, 0xFF, 0xFF, 0xDF, 0xFB, 0xB6, 0xBD, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xDF, 0xF7, 0xBE, 0xBD, 0xF7, 0xEF, 0x7F,  // 138
  0xFE, 0x3E, 0xFA, 0xE6, 0x9D, 0x0D, 0xDF, 0x4C, 0x3A, 0x70, 0xDF, 0x7D, 0x22, 0x1C, 0x0F, 0xF7, 0xB6, 0xB8, 0xC3, 0xBB, 0x9A, 0x7E, 0x98, 0x74, 0xE1, 0xBE, 0xDF, 0xF7, 0xBE, 0xBD, 0xEF, 0xEF, 0xBF,  // 139
  0xFE, 0x3E, 0xFA, 0xDE, 0x6D, 0xF6, 0xBF, 0x37, 0xD9, 0xAF, 0x5F, 0xBC, 0xDD, 0xED, 0xDF, 0xF7, 0xCF, 0xFD, 0xBD, 0xBA, 0x79, 0xBE, 0x6F, 0xB3, 0x5E, 0xBF, 0x3F, 0xCF, 0x8F, 0xFD, 0xEF, 0xEF, 0xBF,  // 140
  0xFE, 0x3E, 0xFA, 0xCE, 0xED, 0x86, 0xBF, 0x76, 0x1B, 0xA0, 0x5F, 0xDD, 0xDD, 0x0D, 0xDF, 0xEF, 0xB7, 0xFD, 0xBD, 0xBA, 0xFB, 0xBE, 0xEC, 0x37, 0x40, 0xBE, 0xB7, 0xE7, 0xF7, 0xFD, 0xEF, 0xEF, 0xBF,  // 141
  0xFF, 0xFE, 0xFA, 0xF6, 0xED, 0x76, 0xBF, 0x75, 0xDB, 0xAF, 0xDF, 0xED, 0xDC, 0xED, 0xDF, 0xEF, 0x7B, 0xFD, 0xBD, 0xBA, 0xFB, 0xBE, 0xEB, 0xB7, 0x5F, 0xBD, 0xCF, 0xF7, 0xF7, 0xFD, 0xEF, 0xEF, 0xBF,  // 142
  0xFF, 0xFE, 0xE6, 0xF6, 0xED, 0x77, 0x3F, 0x75, 0xDB, 0xB7, 0xDF, 0xED, 0xDC, 0xED, 0xDF, 0xDF, 0x7B, 0xFD, 0xB9, 0xB2, 0x7B, 0xBE, 0xEB, 0xB7, 0x6F, 0xBD, 0xCF, 0xF6, 0xF7, 0xFD, 0xF7, 0xEE, 0x7F,  // 143
  0xFF, 0xFE, 0x1E, 0xCE, 0x1D, 0x87, 0x7F, 0x0E, 0x1B, 0xB8, 0x5F, 0x1D, 0xDD, 0x0D, 0xEF, 0x9F, 0x87, 0xFE, 0xC7, 0xCB, 0x9B, 0xBE, 0x1C, 0x37, 0x70, 0xBE, 0x27, 0x0E, 0x0F, 0xFC, 0x38, 0x61, 0xFF,  // 144
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x7F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 145
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 146
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 147
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 148
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 149
  0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xFF,  // 150
  0xFE, 0x1F, 0xFB, 0x7F, 0xEF, 0xFF, 0xFF, 0xBF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xE1, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFB, 0xFF, 0xFD, 0xE1, 0xFF, 0xBF, 0xBE, 0xFF,  // 151
  0xC6, 0xEF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xEF, 0xBB, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xDE, 0xFF, 0xFF, 0xBE, 0xFF,  // 152
  0xC6, 0xED, 0xDB, 0x47, 0xED, 0x3E, 0xED, 0xB1, 0x0D, 0x87, 0x39, 0xE1, 0xD3, 0xCB, 0xEF, 0x1A, 0x70, 0xC5, 0x38, 0x47, 0xD3, 0x84, 0x5D, 0xB0, 0xE2, 0xDB, 0x4F, 0x2F, 0xBF, 0x5D, 0xB9, 0xB6, 0xBB,  // 153
  0xC6, 0x1D, 0xDB, 0x6F, 0xEC, 0xDE, 0xCD, 0xB6, 0xF5, 0x7A, 0xF7, 0xFE, 0xCD, 0x33, 0xE1, 0xB9, 0xAF, 0x5C, 0xD7, 0xAF, 0xCD, 0x7A, 0xD9, 0xAF, 0x6E, 0xBB, 0x34, 0xCF, 0xBF, 0x5D, 0xA7, 0xAE, 0xD7,  // 154
  0xFE, 0xED, 0xDB, 0x6C, 0x6D, 0xDF, 0x4B, 0xB6, 0x05, 0x02, 0x73, 0xF0, 0xDD, 0x7B, 0xEF, 0xBB, 0xA0, 0x5D, 0xD0, 0x2F, 0xDD, 0x02, 0xE9, 0x6F, 0x6E, 0x7B, 0x75, 0xEF, 0xBF, 0x5D, 0xAF, 0x9E, 0xD7,  // 155
  0xFE, 0xED, 0xDB, 0x6F, 0xED, 0xDF, 0x2B, 0xB6, 0xFD, 0x7F, 0xBD, 0xEE, 0xDD, 0x7B, 0xEF, 0xBB, 0xAF, 0xDD, 0xD7, 0xEF, 0xDD, 0x7E, 0xE5, 0x6F, 0x6E, 0xBB, 0x75, 0xEF, 0xBF, 0x5D, 0xAF, 0xAE, 0xD7,  // 156
  0xFE, 0xED, 0x9B, 0x6F, 0xED, 0xDF, 0x33, 0xB7, 0x7D, 0xBF, 0xBD, 0xEE, 0xDD, 0x73, 0xEF, 0xBB, 0xB7, 0xDD, 0xDB, 0xEF, 0xDD, 0xBE, 0xE6, 0x6E, 0x6E, 0xDB, 0x75, 0xCF, 0xDE, 0xD9, 0xA7, 0xB6, 0xE7,  // 157
  0xFE, 0x1E, 0x5B, 0x77, 0xED, 0xDF, 0xB7, 0xB7, 0x85, 0xC2, 0x73, 0xF0, 0xDD, 0x8B, 0xE1, 0xDB, 0xB8, 0x5D, 0xDC, 0x37, 0xDD, 0xC3, 0x76, 0xF1, 0xEE, 0xCB, 0x76, 0x2F, 0xE1, 0xE5, 0xB9, 0xB2, 0xEF,  // 158
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFE, 0x7F, 0xFF, 0xFF, 0xEF,  // 159
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF,  // 160
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF,  // 161
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 162
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 163
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 164
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xDB, 0xFF, 0xFB, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 165
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 166
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x9C, 0x5A, 0x63, 0xC6, 0x21, 0xD2, 0x3D, 0xD8, 0x77, 0x63, 0xD2, 0x30, 0xE9, 0xDB, 0x0F, 0xCB, 0x0B, 0xB7, 0x30, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 167
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0x6D, 0xD9, 0xB7, 0xEE, 0xDE, 0xCD, 0xDE, 0xB7, 0xB7, 0x6F, 0xCD, 0xCF, 0x66, 0xDA, 0xF7, 0x32, 0xF5, 0x74, 0xEF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 168
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0xED, 0xDB, 0xB7, 0xEE, 0xDE, 0xDD, 0xDE, 0xB7, 0xB7, 0x6F, 0xDD, 0xCF, 0x6E, 0xDA, 0x07, 0x7A, 0x05, 0x75, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 169
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0xED, 0xDB, 0xB7, 0xEE, 0xDE, 0xDD, 0xDE, 0xB7, 0xB7, 0x6F, 0xDD, 0xCF, 0x6E, 0xDA, 0xFF, 0x7A, 0xFD, 0x75, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 170
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0xDB, 0xB7, 0xEE, 0xDC, 0xDD, 0xDF, 0x37, 0x36, 0x6F, 0xDD, 0xCE, 0x6E, 0xDB, 0x7F, 0x73, 0x7D, 0x74, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 171
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1D, 0xDB, 0xBB, 0xEE, 0xE3, 0xDD, 0xDF, 0x78, 0xF9, 0x6F, 0xDD, 0xD1, 0xE1, 0xDB, 0x87, 0x8B, 0x86, 0xF7, 0x38, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 172
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 173
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 174
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 175
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 176
};
#endif
